/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import com.cloudimpl.outstack.spring.security.AuthenticationProvider;
import com.cloudimpl.outstack.spring.security.AuthorizationProvider;
import com.cloudimpl.outstack.spring.security.BasicTokenAuthenticationManager;
import com.cloudimpl.outstack.spring.security.BearerTokenAuthenticationManager;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationException;
import com.cloudimpl.outstack.spring.security.TokenProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.ReactiveAuthenticationManagerResolver;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class AuthenticationManagerResolver
implements ReactiveAuthenticationManagerResolver<ServerWebExchange> {
    private final BearerTokenAuthenticationManager bearerTokenAuthentication;
    private final BasicTokenAuthenticationManager basicTokenAuthentication;

    public AuthenticationManagerResolver(ReactiveJwtDecoder jwtDecoder, @Autowired(required=false) AuthenticationProvider authenticationProvider, @Autowired(required=false) AuthorizationProvider authorizationProvider, @Autowired(required=false) TokenProvider tokenProvider) {
        authenticationProvider = authenticationProvider == null ? t -> Mono.error(() -> new RuntimeException("AuthenticationProvider not provisioned")) : authenticationProvider;
        authorizationProvider = authorizationProvider == null ? t -> Mono.error(() -> new PlatformAuthenticationException("AuthorizationProvider not provisioned", null)) : authorizationProvider;
        tokenProvider = tokenProvider == null ? t -> Mono.error(() -> new PlatformAuthenticationException("TokenProvider not provisioned", null)) : tokenProvider;
        this.bearerTokenAuthentication = new BearerTokenAuthenticationManager(jwtDecoder, authenticationProvider, authorizationProvider, tokenProvider);
        this.basicTokenAuthentication = new BasicTokenAuthenticationManager(authenticationProvider, authorizationProvider, tokenProvider);
    }

    public BasicTokenAuthenticationManager getBasicTokenAuthentication() {
        return this.basicTokenAuthentication;
    }

    public BearerTokenAuthenticationManager getBearerTokenAuthentication() {
        return this.bearerTokenAuthentication;
    }

    public Mono<ReactiveAuthenticationManager> resolve(ServerWebExchange c) {
        String path = c.getRequest().getPath().pathWithinApplication().value();
        System.out.println("path:" + path);
        c.getRequest().getHeaders().forEach((k, l) -> System.out.println(k + ":" + l));
        String authorization = (String)c.getRequest().getHeaders().getOrEmpty((Object)"Authorization").stream().findFirst().orElseThrow(() -> new PlatformAuthenticationException("Authorization not found", null));
        if (authorization.toLowerCase().startsWith("bearer")) {
            return Mono.just((Object)this.bearerTokenAuthentication);
        }
        if (authorization.toLowerCase().startsWith("basic")) {
            return Mono.just((Object)this.basicTokenAuthentication);
        }
        return Mono.error(() -> new PlatformAuthenticationException("unknown auth type:" + authorization, null));
    }
}

