/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import com.cloudimpl.outstack.spring.security.SecurityConfig;
import com.cloudimpl.outstack.spring.security.SecurityProperties;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;

@Configuration
public class JwtConfiguration {
    @Bean
    public ReactiveJwtDecoder jwtDecoder(@Qualifier(value="tokenVerificationKey") RSAPublicKey publicKey) {
        return new NimbusReactiveJwtDecoder(publicKey);
    }

    @Bean(name={"tokenVerificationKey"})
    public RSAPublicKey tokenVerificationKey(SecurityProperties securityProperties) {
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(securityProperties.getPublicKeyFile().getInputStream());
            return (RSAPublicKey)RSAPublicKey.class.cast(cert.getPublicKey());
        }
        catch (IOException | CertificateException ex) {
            Logger.getLogger(SecurityConfig.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }
}

