/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import com.cloudimpl.outstack.spring.security.JwtToken;
import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.UUID;

public class JwtTokenBuilder {
    private final JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
    private long expireTimeInSeconds;

    public JwtTokenBuilder() {
        this.builder.issueTime(new Date(Instant.now().toEpochMilli()));
        this.builder.jwtID(UUID.randomUUID().toString());
    }

    public JwtTokenBuilder withClaims(Map<String, Object> claims) {
        claims.entrySet().forEach(e -> this.builder.claim((String)e.getKey(), e.getValue()));
        return this;
    }

    public JwtTokenBuilder withClaim(String key, String value) {
        this.builder.claim(key, (Object)value);
        return this;
    }

    public JwtTokenBuilder withNotBefore(Date date) {
        this.builder.notBeforeTime(date);
        return this;
    }

    public JwtTokenBuilder withExpireTime(long seconds) {
        this.builder.expirationTime(new Date(Instant.now().plusSeconds(seconds).toEpochMilli()));
        this.expireTimeInSeconds = seconds;
        return this;
    }

    public long getExpiretimeInSeconds() {
        return this.expireTimeInSeconds;
    }

    public JwtTokenBuilder withIssuer(String issuer) {
        this.builder.issuer(issuer);
        return this;
    }

    public JwtToken build() {
        return new JwtToken(this.expireTimeInSeconds, this.builder.build());
    }
}

