/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import com.cloudimpl.outstack.spring.security.AuthenticationMeta;
import com.cloudimpl.outstack.spring.security.PlatformGrantedAuthority;
import com.cloudimpl.outstack.spring.security.UserDetail;
import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.Jwt;

public class PlatformAuthenticationToken
extends AbstractAuthenticationToken {
    public static final String TOKEN_CONTEXT_HEADER_NAME = "X-TokenContext";
    private final String principal;
    private final UserDetail userDetail;
    private final AuthenticationMeta authMeta;
    private Jwt jwtToken;
    private Authentication _systemToken;
    private Object response;

    public PlatformAuthenticationToken(AuthenticationMeta authMeta, String principal, Collection<PlatformGrantedAuthority> authorities, UserDetail userDetail) {
        super(authorities);
        this.principal = principal;
        this.userDetail = userDetail;
        this.authMeta = authMeta;
    }

    public PlatformAuthenticationToken copy(Collection<PlatformGrantedAuthority> authorities) {
        PlatformAuthenticationToken token = new PlatformAuthenticationToken(this.authMeta, this.principal, authorities, this.userDetail);
        token.jwtToken = this.jwtToken;
        return token;
    }

    public Object getCredentials() {
        return this._systemToken.getCredentials();
    }

    public Object getPrincipal() {
        return this._systemToken.getPrincipal();
    }

    public AuthenticationMeta getAuthMeta() {
        return this.authMeta;
    }

    public Jwt getJwtToken() {
        return this.jwtToken;
    }

    public PlatformAuthenticationToken setJwtToken(Jwt jwtToken) {
        this.jwtToken = jwtToken;
        return this;
    }

    public PlatformAuthenticationToken setResponse(Object response) {
        this.response = response;
        return this;
    }

    public Object getResponse() {
        return this.response;
    }

    public Authentication getSystemToken() {
        return this._systemToken;
    }

    public void setSystemToken(Authentication _systemToken) {
        this._systemToken = _systemToken;
    }

    public static enum TokenFlow {
        AUTHENTICATION_FLOW,
        TOKEN_FLOW,
        AUTHORIZATION_FLOW;

    }
}

