/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

@ConfigurationProperties(prefix="jwt-auth")
public class SecurityProperties {
    private static final Logger log = LoggerFactory.getLogger(SecurityProperties.class);
    private Resource publicKeyFile = ResourceSelector.load("jwtauth.crt");
    private Resource privateKeyFile = ResourceSelector.load("jwtauth.jks");

    public Resource getPublicKeyFile() {
        return this.publicKeyFile;
    }

    public Resource getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public void setPublicKeyFile(Resource publicKeyFile) {
        this.publicKeyFile = publicKeyFile;
    }

    public void setPrivateKeyFile(Resource privateKeyFile) {
        this.privateKeyFile = privateKeyFile;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SecurityProperties)) {
            return false;
        }
        SecurityProperties other = (SecurityProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Resource this$publicKeyFile = this.getPublicKeyFile();
        Resource other$publicKeyFile = other.getPublicKeyFile();
        if (this$publicKeyFile == null ? other$publicKeyFile != null : !this$publicKeyFile.equals(other$publicKeyFile)) {
            return false;
        }
        Resource this$privateKeyFile = this.getPrivateKeyFile();
        Resource other$privateKeyFile = other.getPrivateKeyFile();
        return !(this$privateKeyFile == null ? other$privateKeyFile != null : !this$privateKeyFile.equals(other$privateKeyFile));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SecurityProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Resource $publicKeyFile = this.getPublicKeyFile();
        result = result * 59 + ($publicKeyFile == null ? 43 : $publicKeyFile.hashCode());
        Resource $privateKeyFile = this.getPrivateKeyFile();
        result = result * 59 + ($privateKeyFile == null ? 43 : $privateKeyFile.hashCode());
        return result;
    }

    public String toString() {
        return "SecurityProperties(publicKeyFile=" + this.getPublicKeyFile() + ", privateKeyFile=" + this.getPrivateKeyFile() + ")";
    }

    public static final class ResourceSelector {
        public static Resource load(String resourceName) {
            String r = resourceName.replaceAll("\\.", "_");
            String val = System.getenv(r);
            if (val == null) {
                log.info("resource {} loaded from classpath", (Object)resourceName);
                return new ClassPathResource(resourceName);
            }
            log.info("resource {} loaded from environment variable {}", (Object)resourceName, (Object)r);
            return new ByteArrayResource(Base64.getDecoder().decode(val.replaceAll(" ", "")));
        }
    }
}

