/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security;

import com.cloudimpl.outstack.spring.security.Auth2Util;
import com.cloudimpl.outstack.spring.security.AuthenticationMeta;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.authentication.ServerFormLoginAuthenticationConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ServerFormLoginAuthenticationConverterEx
extends ServerFormLoginAuthenticationConverter {
    private final String usernameParameter = "username";
    private final String passwordParameter = "password";
    private final String authorizationKeyParameter = "authKey";

    public Mono<Authentication> apply(ServerWebExchange exchange) {
        if (exchange.getResponse().getHeaders().getFirst("Access-Control-Allow-Origin") == null) {
            exchange.getResponse().getHeaders().add("Access-Control-Allow-Origin", "*");
            exchange.getResponse().getHeaders().add("Access-Control-Allow-Headers", "*");
            exchange.getResponse().getHeaders().add("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE");
        }
        if (exchange.getRequest().getMethod() == HttpMethod.OPTIONS) {
            return Mono.empty();
        }
        return exchange.getFormData().flatMap(data -> this.createAuthentication(exchange, (MultiValueMap<String, String>)data));
    }

    private Mono<UsernamePasswordAuthenticationToken> createAuthentication(ServerWebExchange exchange, MultiValueMap<String, String> data) {
        String context = exchange.getRequest().getHeaders().getFirst("X-TokenContext");
        String username = (String)data.getFirst((Object)this.usernameParameter);
        String password = (String)data.getFirst((Object)this.passwordParameter);
        if (username == null || password == null) {
            return Mono.empty();
        }
        String authKey = (String)data.getFirst((Object)this.authorizationKeyParameter);
        AuthenticationMeta meta = Auth2Util.createAuthMeta(authKey, context, exchange);
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        token.setDetails((Object)meta);
        return Mono.just((Object)token);
    }
}

