/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security.domain;

import com.cloudimpl.outstack.runtime.domainspec.DomainEventException;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.runtime.domainspec.RootEntity;
import com.cloudimpl.outstack.spring.security.domain.AuthClientRegistered;
import com.cloudimpl.outstack.spring.security.domain.AuthClientUpdated;
import java.util.LinkedList;
import java.util.List;

public class AuthClient
extends RootEntity {
    private final String clientId;
    private String secret;
    private List<String> redirectUrls = new LinkedList<String>();

    public AuthClient(String clientId) {
        this.clientId = clientId;
    }

    public String entityId() {
        return this.clientId;
    }

    private void applyEvent(AuthClientRegistered event) {
        this.secret = event.getSecret();
        this.redirectUrls = event.getRedirectUrls();
    }

    private void applyEvent(AuthClientUpdated event) {
        this.secret = event.getSecret();
        this.redirectUrls = event.getRedirectUrls();
    }

    protected void apply(Event event) {
        switch (event.getClass().getSimpleName()) {
            case "AuthClientRegistered": {
                this.applyEvent((AuthClientRegistered)event);
                break;
            }
            case "AuthClientUpdated": {
                this.applyEvent((AuthClientUpdated)event);
                break;
            }
            default: {
                throw new DomainEventException(DomainEventException.ErrorCode.UNHANDLED_EVENT, "unhandled event:" + event.getClass().getName(), new Object[0]);
            }
        }
    }

    public String idField() {
        return "clientId";
    }
}

