/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.security.service;

import com.cloudimpl.outstack.common.CloudMessage;
import com.cloudimpl.outstack.core.CloudService;
import com.cloudimpl.outstack.spring.component.Cluster;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationException;
import com.cloudimpl.outstack.spring.security.PlatformAuthenticationToken;
import com.cloudimpl.outstack.spring.security.UserLoginResponse;
import com.cloudimpl.outstack.spring.security.service.AuthorizeKeyRequest;
import com.cloudimpl.outstack.spring.security.service.AuthorizeRequest;
import com.cloudimpl.outstack.spring.security.service.AuthorizeResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class AuthenticationHelperService {
    @Value(value="${outstack.api-gateway.authService.domainOwner:@Null}")
    private String domainOwner;
    @Value(value="${outstack.api-gateway.authService.domainContext:@Null}")
    private String domainContext;
    @Value(value="${outstack.api-gateway.authService.version:@Null}")
    private String version;
    @Value(value="${outstack.api-gateway.authService.serviceName:@Null}")
    private String serviceName;
    @Value(value="${outstack.api-gateway.authService.pkceEnable:false}")
    private boolean pkceEnable;
    @Autowired
    Cluster cluster;
    private String authService = null;

    public Mono<AuthorizeResponse> authorize(AuthorizeRequest req) {
        if ((req.getCodeChallenge() == null || req.getCodeChallengeMethod() == null) && this.pkceEnable) {
            return Mono.error((Throwable)((Object)new PlatformAuthenticationException("PKCE mandatory", null)));
        }
        return this.cluster.requestReply(null, "AuthenticationService", CloudMessage.builder().withData((Object)req).withKey(((CloudService)this.cluster.getServiceRegistry().findLocalByName("AuthenticationService").orElseThrow(() -> new PlatformAuthenticationException("auth service not found", null))).id()).build());
    }

    private PlatformAuthenticationToken onAuth(UserLoginResponse resp) {
        return null;
    }

    public Mono<AuthorizeRequest> getAuthRequest(String key) {
        if (key == null) {
            return Mono.empty();
        }
        String[] keys = key.split(",");
        if (keys.length != 2) {
            return Mono.error(() -> new PlatformAuthenticationException("invalid key", null));
        }
        return this.cluster.requestReply(null, "AuthenticationService", CloudMessage.builder().withData((Object)new AuthorizeKeyRequest(key)).withKey(keys[1]).build());
    }
}

