/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.service;

import com.cloudimpl.outstack.runtime.domainspec.Command;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

class AuthClientCommand
extends Command {
    private final String clientId;
    private String secret;
    private List<String> redirectUrls = new LinkedList<String>();

    public AuthClientCommand(Builder builder) {
        super((Command.Builder)builder);
        this.clientId = builder.clientId;
        this.secret = builder.secret;
        this.redirectUrls = builder.redirectUrls;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getSecret() {
        return this.secret;
    }

    public List<String> getRedirectUrls() {
        return this.redirectUrls;
    }

    public static final class Builder
    extends Command.Builder {
        private String clientId;
        private String secret;
        private List<String> redirectUrls = new LinkedList<String>();

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withSecret(String secret) {
            this.secret = secret;
            return this;
        }

        public Builder withRedirectUrls(String ... urls) {
            this.redirectUrls.addAll(Arrays.asList(urls));
            return this;
        }

        public AuthClientCommand build() {
            return new AuthClientCommand(this);
        }
    }
}

