/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.service;

import com.cloudimpl.outstack.common.CloudMessage;
import com.cloudimpl.outstack.common.RouterType;
import com.cloudimpl.outstack.core.CloudUtil;
import com.cloudimpl.outstack.core.annon.CloudFunction;
import com.cloudimpl.outstack.core.annon.Router;
import com.cloudimpl.outstack.runtime.EntityIdHelper;
import com.cloudimpl.outstack.runtime.EventRepositoryFactory;
import com.cloudimpl.outstack.runtime.EventRepositoy;
import com.cloudimpl.outstack.runtime.common.StreamProcessor;
import com.cloudimpl.outstack.runtime.domainspec.ChildEntity;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.Query;
import com.cloudimpl.outstack.runtime.repo.RepoStreamingReq;
import com.cloudimpl.outstack.runtime.repo.StreamEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

@CloudFunction(name="RepositoryStreamingService")
@Router(routerType=RouterType.NODE_ID)
public class RepositoryStreamingService
implements Function<CloudMessage, Flux> {
    private static final Logger log = LoggerFactory.getLogger(RepositoryStreamingService.class);

    @Override
    public Flux<StreamEvent> apply(CloudMessage t) {
        RepoStreamingReq req = (RepoStreamingReq)t.data();
        StreamProcessor eventStream = EventRepositoryFactory.getEventStream();
        Flux eventsFlux = eventStream.flux().filter(e -> {
            Entity entity = (Entity)e.getEvent();
            String rootType = entity.isRoot() ? entity.getClass().getName() : ((ChildEntity)ChildEntity.class.cast(entity)).rootType().getName();
            Optional listOptional = req.getResources(rootType);
            if (listOptional.isPresent()) {
                List list = (List)listOptional.get();
                for (RepoStreamingReq.ResourceInfo info : list) {
                    if (!(info.getChildType() != null && entity instanceof ChildEntity ? this.onChildEventListener(info, entity) : info.getChildType() == null && this.onRootEventListener(info, entity))) continue;
                    return true;
                }
            }
            return false;
        }).cast(StreamEvent.class);
        return Flux.merge((Publisher[])new Publisher[]{this.subscribeToRootResources(req), eventsFlux});
    }

    private boolean onRootEventListener(RepoStreamingReq.ResourceInfo info, Entity entity) {
        if (!info.getEntityType().equals(entity.getClass().getName())) {
            return false;
        }
        if (info.getTenantId() != null && info.getTenantId().equals("*")) {
            if (info.getEntityId().equals("*")) {
                return true;
            }
            if (EntityIdHelper.isTechnicalId((String)info.getEntityId())) {
                return info.getEntityId().equals(entity.id());
            }
            return info.getEntityId().equals(entity.entityId());
        }
        if (info.getTenantId() == null && entity.getTenantId() == null) {
            if (info.getEntityId().equals("*")) {
                return true;
            }
            if (EntityIdHelper.isTechnicalId((String)info.getEntityId())) {
                return info.getEntityId().equals(entity.id());
            }
            return info.getEntityId().equals(entity.entityId());
        }
        if (info.getTenantId() != null && entity.getTenantId() != null && info.getTenantId().equals(entity.getTenantId())) {
            if (info.getEntityId().equals("*")) {
                return true;
            }
            if (EntityIdHelper.isTechnicalId((String)info.getEntityId())) {
                return info.getEntityId().equals(entity.id());
            }
            return info.getEntityId().equals(entity.entityId());
        }
        return false;
    }

    private boolean onChildEventListener(RepoStreamingReq.ResourceInfo info, Entity entity) {
        if (!info.getChildType().equals("*") && !info.getChildType().equals(entity.getClass().getName())) {
            return false;
        }
        ChildEntity child = (ChildEntity)entity;
        if (!info.getEntityId().equals("*")) {
            if (EntityIdHelper.isTechnicalId((String)info.getEntityId())) {
                if (!info.getEntityId().equals(child.rootId())) {
                    return false;
                }
            } else {
                throw new RuntimeException("resource " + info.getEntityType() + " rootId should be technical id");
            }
        }
        if (info.getTenantId() != null && info.getTenantId().equals("*")) {
            if (info.getChildId().equals("*")) {
                return true;
            }
            if (EntityIdHelper.isTechnicalId((String)info.getChildId())) {
                return info.getChildId().equals(entity.id());
            }
            return info.getChildId().equals(entity.entityId());
        }
        if (info.getTenantId() == null && entity.getTenantId() == null) {
            if (info.getChildId().equals("*")) {
                return true;
            }
            if (EntityIdHelper.isTechnicalId((String)info.getChildId())) {
                return info.getChildId().equals(entity.id());
            }
            return info.getChildId().equals(entity.entityId());
        }
        if (info.getTenantId() != null && entity.getTenantId() != null && info.getTenantId().equals(entity.getTenantId())) {
            if (info.getChildId().equals("*")) {
                return true;
            }
            if (EntityIdHelper.isTechnicalId((String)info.getChildId())) {
                return info.getChildId().equals(entity.id());
            }
            return info.getChildId().equals(entity.entityId());
        }
        return false;
    }

    private Flux<StreamEvent> subscribeToRootResources(RepoStreamingReq req) {
        return Flux.fromIterable((Iterable)req.getInitialDownloadResources()).map(s -> this.getResources((RepoStreamingReq.ResourceInfo)s)).flatMapIterable(l -> l);
    }

    private Collection<StreamEvent> getResources(RepoStreamingReq.ResourceInfo resourceInfo) {
        if (resourceInfo.getChildType() == null) {
            return this.getEventRepo(resourceInfo.getEntityType()).getAllByRootType(CloudUtil.classForName((String)resourceInfo.getEntityType()), resourceInfo.getTenantId(), new Query.PagingRequest(0, Integer.MAX_VALUE, Collections.EMPTY_LIST, Collections.EMPTY_MAP, resourceInfo.getSearchParam(), null)).getItems().stream().map(r -> new StreamEvent(StreamEvent.Action.ADD, r)).collect(Collectors.toList());
        }
        return this.getEventRepo(resourceInfo.getEntityType()).getAllChildByType(CloudUtil.classForName((String)resourceInfo.getEntityType()), resourceInfo.getEntityId(), CloudUtil.classForName((String)resourceInfo.getChildType()), resourceInfo.getTenantId(), new Query.PagingRequest(0, Integer.MAX_VALUE, Collections.EMPTY_LIST, Collections.EMPTY_MAP, resourceInfo.getSearchParam(), null)).getItems().stream().map(r -> new StreamEvent(StreamEvent.Action.ADD, r)).collect(Collectors.toList());
    }

    private EventRepositoy getEventRepo(String rootType) {
        return (EventRepositoy)EventRepositoryFactory.getRepository((Class)CloudUtil.classForName((String)rootType)).orElseThrow(() -> new RuntimeException("repository " + rootType + " not found"));
    }
}

