/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.service;

import com.cloudimpl.outstack.common.CloudMessage;
import com.cloudimpl.outstack.common.FluxMap;
import com.cloudimpl.outstack.common.GsonCodec;
import com.cloudimpl.outstack.common.RouterType;
import com.cloudimpl.outstack.core.CloudService;
import com.cloudimpl.outstack.core.CloudServiceDescriptor;
import com.cloudimpl.outstack.core.Inject;
import com.cloudimpl.outstack.core.Named;
import com.cloudimpl.outstack.core.ServiceRegistryReadOnly;
import com.cloudimpl.outstack.core.annon.CloudFunction;
import com.cloudimpl.outstack.core.annon.Router;
import com.cloudimpl.outstack.core.logger.ILogger;
import com.cloudimpl.outstack.runtime.EntityIdHelper;
import com.cloudimpl.outstack.runtime.EventRepositoryFactory;
import com.cloudimpl.outstack.runtime.EventRepositoy;
import com.cloudimpl.outstack.runtime.domain.CommandHandlerRegistered;
import com.cloudimpl.outstack.runtime.domain.DomainContext;
import com.cloudimpl.outstack.runtime.domain.DomainContextCreated;
import com.cloudimpl.outstack.runtime.domain.EventHandlerRegistered;
import com.cloudimpl.outstack.runtime.domain.QueryHandlerRegistered;
import com.cloudimpl.outstack.runtime.domain.ServiceModule;
import com.cloudimpl.outstack.runtime.domain.ServiceModuleProvisioned;
import com.cloudimpl.outstack.runtime.domain.ServiceModuleRef;
import com.cloudimpl.outstack.runtime.domain.ServiceModuleRefCreated;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.EntityHelper;
import com.cloudimpl.outstack.runtime.domainspec.Event;
import com.cloudimpl.outstack.spring.component.SpringServiceDescriptor;
import com.cloudimpl.outstack.spring.service.ServiceDescriptorContextManager;
import com.cloudimpl.outstack.spring.util.SpringUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import reactor.core.publisher.Flux;

@CloudFunction(name="RestController")
@Router(routerType=RouterType.LOCAL)
public class RestControllerService
implements Function<CloudMessage, CloudMessage> {
    private Flux<FluxMap.Event<String, CloudService>> serviceFlux;
    private ServiceDescriptorContextManager serviceManager;
    private ILogger logger;
    private EventRepositoryFactory eventRepoFactory;
    private Map<String, DomainContext> domainContexts = new ConcurrentHashMap<String, DomainContext>();
    public static FluxMap<String, DomainContext> domainContextsFlux = new FluxMap("DomainContext");
    public static RestControllerService instance;
    private ServiceRegistryReadOnly serviceRegistry;

    @Inject
    public RestControllerService(ServiceRegistryReadOnly serviceRegistry, @Named(value="@serviceFlux") Flux<FluxMap.Event<String, CloudService>> serviceFlux, ServiceDescriptorContextManager serviceManager, @Named(value="MemRepositoryFactory") EventRepositoryFactory eventRepoFactory, ILogger logger) {
        this.serviceRegistry = serviceRegistry;
        instance = this;
        this.logger = logger.createSubLogger(RestControllerService.class);
        this.eventRepoFactory = eventRepoFactory;
        this.serviceFlux = serviceFlux;
        this.serviceManager = serviceManager;
        this.serviceFlux.filter(s -> s.getType() == FluxMap.Event.Type.ADD).map(s -> this.getSpringDescriptor(((CloudService)s.getValue()).getDescriptor())).filter(d -> d.isPresent()).map(d -> (SpringServiceDescriptor)d.get()).doOnNext(this::addCmdDescriptor).doOnError(err -> logger.exception(err, "rest controller service error:", new Object[0])).subscribe();
        this.serviceFlux.filter(s -> s.getType() == FluxMap.Event.Type.ADD).map(s -> this.getSpringQueryDescriptor(((CloudService)s.getValue()).getDescriptor())).filter(d -> d.isPresent()).map(d -> (SpringServiceDescriptor)d.get()).doOnNext(this::addQueryDescriptor).doOnError(err -> logger.exception(err, "rest controller service error:", new Object[0])).subscribe();
    }

    private Optional<SpringServiceDescriptor> getSpringDescriptor(CloudServiceDescriptor serviceDescriptor) {
        String str = (String)serviceDescriptor.getAttr().get("serviceMeta");
        if (str != null) {
            this.logger.info("service descriptor {0}", new Object[]{str});
            SpringServiceDescriptor serviceDesc = (SpringServiceDescriptor)GsonCodec.decode(SpringServiceDescriptor.class, (String)str);
            return Optional.of(serviceDesc);
        }
        return Optional.empty();
    }

    public static void refresh(String rootTypePlural) {
        instance._refresh(rootTypePlural);
    }

    public void _refresh(String rootTypePlural) {
        this.logger.warn("refreshing  rootType : {0}", new Object[]{rootTypePlural});
        this.serviceRegistry.services().filter(srv -> srv.getDescriptor().getAttr().get("serviceMeta") != null).map(srv -> (String)srv.getDescriptor().getAttr().get("serviceMeta")).map(s -> (SpringServiceDescriptor)GsonCodec.decode(SpringServiceDescriptor.class, (String)s)).filter(s -> s.getPlural().equals(rootTypePlural)).forEach(this::addCmdDescriptor);
        this.serviceRegistry.services().filter(srv -> srv.getDescriptor().getAttr().get("serviceQueryMeta") != null).map(srv -> (String)srv.getDescriptor().getAttr().get("serviceQueryMeta")).map(s -> (SpringServiceDescriptor)GsonCodec.decode(SpringServiceDescriptor.class, (String)s)).filter(s -> s.getPlural().equals(rootTypePlural)).forEach(this::addQueryDescriptor);
    }

    private Optional<SpringServiceDescriptor> getSpringQueryDescriptor(CloudServiceDescriptor serviceDescriptor) {
        String str = (String)serviceDescriptor.getAttr().get("serviceQueryMeta");
        if (str != null) {
            this.logger.info("service query descriptor {0}", new Object[]{str});
            SpringServiceDescriptor serviceDesc = (SpringServiceDescriptor)GsonCodec.decode(SpringServiceDescriptor.class, (String)str);
            return Optional.of(serviceDesc);
        }
        return Optional.empty();
    }

    private void addCmdDescriptor(SpringServiceDescriptor desc) {
        try {
            this.serviceManager.putCmdContext(desc.getApiContext(), desc.getVersion(), desc);
            this.addEntities(desc);
        }
        catch (Exception ex) {
            this.logger.exception((Throwable)ex, "addCmdDescriptor", new Object[0]);
        }
    }

    private void addQueryDescriptor(SpringServiceDescriptor desc) {
        try {
            this.serviceManager.putQueryContext(desc.getApiContext(), desc.getVersion(), desc);
            this.addEntities(desc);
        }
        catch (Exception ex) {
            this.logger.exception((Throwable)ex, "addQueryDescriptor", new Object[0]);
        }
    }

    @Override
    public CloudMessage apply(CloudMessage req) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void addEntities(SpringServiceDescriptor desc) {
        ServiceModule service = this.eventRepoFactory.createOrGetRepository(ServiceModule.class).getRootById(ServiceModule.class, desc.getDomainOwner() + ":" + desc.getDomainContext() + ":" + desc.getRootType(), null).orElseGet(() -> this.createMicroService(desc));
        this.addActions(this.eventRepoFactory.createOrGetRepository(ServiceModule.class), service.id(), desc.getRootType(), desc, desc.getRootActions());
        desc.entityDescriptors().forEach(ed -> this.addActions(this.eventRepoFactory.createOrGetRepository(ServiceModule.class), service.id(), ed.getName(), desc, desc.getChildActions(ed.getName())));
    }

    private ServiceModule createMicroService(SpringServiceDescriptor desc) {
        DomainContext domainContext = this.createOrGetDomainContext(desc);
        String id = "id-i" + SpringUtil.toMD5(desc.getDomainOwner() + "/" + desc.getDomainContext() + ":" + desc.getRootType());
        ServiceModuleProvisioned provisioned = new ServiceModuleProvisioned(desc.getServiceName(), desc.getDomainOwner() + ":" + desc.getDomainContext() + ":" + desc.getRootType(), desc.getVersion(), desc.getApiContext(), desc.getTenancy());
        provisioned.setId(id);
        provisioned.setRootId(id);
        provisioned.setAction(Event.Action.CREATE);
        EntityHelper.setVersion((Event)provisioned, (String)Entity.getVersion(ServiceModule.class));
        EntityHelper.setCreatedDate((Event)provisioned, (long)System.currentTimeMillis());
        String childId = "id-i" + SpringUtil.toMD5(desc.getDomainOwner() + "/" + desc.getDomainContext() + ":" + id);
        ServiceModuleRefCreated refEvent = new ServiceModuleRefCreated(EntityIdHelper.idToRefId((String)id), domainContext.entityId());
        refEvent.setId(childId);
        refEvent.setRootId(domainContext.id());
        refEvent.setAction(Event.Action.CREATE);
        EntityHelper.setVersion((Event)refEvent, (String)Entity.getVersion(ServiceModuleRef.class));
        EntityHelper.setCreatedDate((Event)refEvent, (long)System.currentTimeMillis());
        this.eventRepoFactory.createOrGetRepository(DomainContext.class).applyEvent((Event)refEvent);
        return (ServiceModule)this.eventRepoFactory.createOrGetRepository(ServiceModule.class).applyEvent((Event)provisioned);
    }

    private void addActions(EventRepositoy eventRepo, String rootId, String targetEntity, SpringServiceDescriptor serviceDesc, Collection<SpringServiceDescriptor.ActionDescriptor> actions) {
        actions.stream().filter(action -> action.getActionType() == SpringServiceDescriptor.ActionDescriptor.ActionType.COMMAND_HANDLER).forEach(action -> {
            CommandHandlerRegistered event = new CommandHandlerRegistered(action.getName(), targetEntity, serviceDesc.getRootType());
            String childId = "id-i" + SpringUtil.toMD5(serviceDesc.getDomainOwner() + "/" + serviceDesc.getDomainContext() + ":" + serviceDesc.getRootType() + ":cmd:" + action.getName());
            event.setId(childId);
            event.setRootId(rootId);
            event.setAction(Event.Action.CREATE);
            EntityHelper.setVersion((Event)event, (String)Entity.getVersion(ServiceModule.class));
            EntityHelper.setCreatedDate((Event)event, (long)System.currentTimeMillis());
            eventRepo.applyEvent((Event)event);
        });
        actions.stream().filter(action -> action.getActionType() == SpringServiceDescriptor.ActionDescriptor.ActionType.EVENT_HANDLER).forEach(action -> {
            EventHandlerRegistered event = new EventHandlerRegistered(action.getName(), targetEntity, serviceDesc.getRootType());
            String childId = "id-i" + SpringUtil.toMD5(serviceDesc.getDomainOwner() + "/" + serviceDesc.getDomainContext() + ":" + serviceDesc.getRootType() + ":evt:" + action.getName());
            event.setId(childId);
            event.setRootId(rootId);
            event.setAction(Event.Action.CREATE);
            EntityHelper.setVersion((Event)event, (String)Entity.getVersion(ServiceModule.class));
            EntityHelper.setCreatedDate((Event)event, (long)System.currentTimeMillis());
            eventRepo.applyEvent((Event)event);
        });
        actions.stream().filter(action -> action.getActionType() == SpringServiceDescriptor.ActionDescriptor.ActionType.QUERY_HANDLER).forEach(action -> {
            QueryHandlerRegistered event = new QueryHandlerRegistered(action.getName(), targetEntity, serviceDesc.getRootType());
            String childId = "id-i" + SpringUtil.toMD5(serviceDesc.getDomainOwner() + "/" + serviceDesc.getDomainContext() + ":" + serviceDesc.getRootType() + ":query:" + action.getName());
            event.setId(childId);
            event.setRootId(rootId);
            event.setAction(Event.Action.CREATE);
            EntityHelper.setCreatedDate((Event)event, (long)System.currentTimeMillis());
            EntityHelper.setVersion((Event)event, (String)Entity.getVersion(ServiceModule.class));
            eventRepo.applyEvent((Event)event);
        });
    }

    private DomainContext createOrGetDomainContext(SpringServiceDescriptor serviceDesc) {
        return this.domainContexts.computeIfAbsent(serviceDesc.getDomainOwner() + "/" + serviceDesc.getDomainContext(), id -> {
            String tid = "id-i" + SpringUtil.toMD5(serviceDesc.getDomainOwner() + "/" + serviceDesc.getDomainContext() + ":" + id);
            DomainContextCreated event = new DomainContextCreated(id, serviceDesc.getDomainOwner(), serviceDesc.getDomainContext());
            event.setId(tid);
            event.setRootId(tid);
            event.setAction(Event.Action.CREATE);
            EntityHelper.setVersion((Event)event, (String)Entity.getVersion(DomainContext.class));
            EntityHelper.setCreatedDate((Event)event, (long)System.currentTimeMillis());
            DomainContext ctx = (DomainContext)this.eventRepoFactory.createOrGetRepository(DomainContext.class).applyEvent((Event)event);
            domainContextsFlux.put(id, (Object)ctx);
            return ctx;
        });
    }
}

