/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.service.config;

import com.cloudimpl.outstack.runtime.configs.ConfigEntity;
import com.cloudimpl.outstack.runtime.configs.ConfigGroupEntity;
import com.cloudimpl.outstack.runtime.repo.RepoStreamingReq;
import com.cloudimpl.outstack.runtime.repo.StreamEvent;
import com.cloudimpl.outstack.spring.component.Cluster;
import com.cloudimpl.outstack.spring.component.StreamClient;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class GlobalConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(GlobalConfigurationService.class);
    @Value(value="${outstack.configuration.globalendpoint:#{null}}")
    private String globalEndPoint;
    @Autowired
    private Cluster cluster;
    private Map<String, String> configMap = new ConcurrentHashMap<String, String>();
    private StreamClient streamClient;
    private String globalGroupEntityId;

    @PostConstruct
    private void init() {
        if (this.globalEndPoint == null) {
            log.info("global configuration endpoint not setup");
            return;
        }
        this.streamClient = new StreamClient(this.cluster);
        String[] configs = this.globalEndPoint.split("/");
        if (configs.length != 2) {
            throw new RuntimeException("Invalid global endpoint configuration " + this.globalEndPoint);
        }
        this.loadGlobalGroupEntity(configs[0].trim(), configs[1].trim());
    }

    private void loadGlobalGroupEntity(String domainOwner, String domainContext) {
        this.streamClient.subscribeToMicroService("global configurations sync ", domainOwner, domainContext, new RepoStreamingReq(Arrays.asList(new RepoStreamingReq.ResourceInfo(ConfigGroupEntity.class.getName(), "Global", null)), Arrays.asList(new RepoStreamingReq.ResourceInfo(ConfigGroupEntity.class.getName(), "Global", null)))).doOnNext(e -> this.updateGlobalGroupEntityId((ConfigGroupEntity)e.getEvent(), domainOwner, domainContext)).doOnError(err -> log.error("error syncing global configuration ", err)).subscribe();
    }

    private void updateGlobalGroupEntityId(ConfigGroupEntity configGroupEntity, String domainOwner, String domainContext) {
        if (this.globalGroupEntityId != null) {
            return;
        }
        if (configGroupEntity.getGroupName().equals("Global")) {
            this.globalGroupEntityId = configGroupEntity.id();
            log.info("updated globalGroupEntityId {}", (Object)this.globalGroupEntityId);
        }
        if (this.globalGroupEntityId != null) {
            this.streamClient.subscribeToMicroService("global configurations sync ", domainOwner, domainContext, new RepoStreamingReq(Arrays.asList(new RepoStreamingReq.ResourceInfo(ConfigGroupEntity.class.getName(), this.globalGroupEntityId, ConfigEntity.class.getName(), "*", null)), Arrays.asList(new RepoStreamingReq.ResourceInfo(ConfigGroupEntity.class.getName(), "*", ConfigEntity.class.getName(), "*", null)))).doOnNext(e -> this.updateCache((StreamEvent)e)).doOnError(err -> log.error("error syncing global configuration ", err)).subscribe();
        }
    }

    private void updateCache(StreamEvent streamEvent) {
        ConfigEntity configEntity;
        if (streamEvent.getAction() == StreamEvent.Action.ADD && (configEntity = (ConfigEntity)streamEvent.getEvent()).rootId().equals(this.globalGroupEntityId)) {
            this.configMap.put(configEntity.getConfigName(), configEntity.getConfigValue());
            log.info("inserted/updated global config {}:{}", (Object)configEntity.getConfigName(), (Object)configEntity.getConfigValue());
        }
    }

    public String getConfigString(String name) {
        return this.configMap.get(name);
    }

    public Integer getConfigInteger(String name) {
        return Integer.valueOf(this.configMap.getOrDefault(name, "0"));
    }

    public Boolean getConfigBoolean(String name) {
        return Boolean.valueOf(this.configMap.getOrDefault(name, "false"));
    }
}

