/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.service.iam;

import com.cloudimpl.outstack.common.FluxMap;
import com.cloudimpl.outstack.common.RetryUtil;
import com.cloudimpl.outstack.runtime.EntityIdHelper;
import com.cloudimpl.outstack.runtime.ResultSet;
import com.cloudimpl.outstack.runtime.ValidationErrorException;
import com.cloudimpl.outstack.runtime.domain.DomainContext;
import com.cloudimpl.outstack.runtime.domain.Policy;
import com.cloudimpl.outstack.runtime.domain.PolicyRef;
import com.cloudimpl.outstack.runtime.domain.PolicyStatement;
import com.cloudimpl.outstack.runtime.domain.PolicyStatementRef;
import com.cloudimpl.outstack.runtime.domain.Role;
import com.cloudimpl.outstack.runtime.domainspec.Entity;
import com.cloudimpl.outstack.runtime.domainspec.Query;
import com.cloudimpl.outstack.runtime.domainspec.QueryByIdRequest;
import com.cloudimpl.outstack.runtime.repo.RepoStreamingReq;
import com.cloudimpl.outstack.runtime.repo.StreamEvent;
import com.cloudimpl.outstack.spring.component.Cluster;
import com.cloudimpl.outstack.spring.component.StreamClient;
import com.cloudimpl.outstack.spring.service.RestControllerService;
import com.cloudimpl.outstack.spring.service.iam.TenantProvider;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.retry.Retry;

@Component
public class IAMCache {
    private static final Logger log = LoggerFactory.getLogger(IAMCache.class);
    @Autowired
    private Cluster cluster;
    @Autowired(required=false)
    private TenantProvider tenantProvider;
    private StreamClient streamClient;
    private FluxMap<String, Entity> entityCache;
    @Value(value="${outstack.apiGateway.syncPolicies:false}")
    private boolean syncPolicies;
    @Value(value="${outstack.apiGateway.roleServiceName:#{null}}")
    private String roleServiceName;
    @Value(value="${outstack.apiGateway.roleDomainOwner:#{null}}")
    private String roleDomainOwner;
    @Value(value="${outstack.apiGateway.roleDomainContext:#{null}}")
    private String roleDomainContext;
    private Set<Object> inMemoryEntities = new ConcurrentSkipListSet<Object>();

    @PostConstruct
    private void init() {
        log.info("checking sync policies status ,{}", (Object)this.syncPolicies);
        if (!this.syncPolicies) {
            log.info("sync policies disabled");
            return;
        }
        this.streamClient = new StreamClient(this.cluster);
        this.entityCache = new FluxMap("entityCache", Schedulers.newSingle((String)"iamCache"));
        this.subscribeToPolicyRef();
        this.subscribeToPolicyStatementRef();
        this.syncRole();
        this.syncAllMicroServices();
    }

    private void syncAllMicroServices() {
        RestControllerService.domainContextsFlux.flux("IAMCache:domainContext").doOnNext(d -> log.info("subscribe to microservice {}/{}", (Object)((DomainContext)d.getValue()).getDomainOwner(), (Object)((DomainContext)d.getValue()).getDomainContext())).doOnNext(d -> this.subscribeToMicroService(((DomainContext)d.getValue()).getDomainOwner(), ((DomainContext)d.getValue()).getDomainContext())).doOnError(err -> log.error("error subscribing to domain context", err)).subscribe();
    }

    private void syncRole() {
        log.info("sync roles . {}/{}/{}", new Object[]{this.roleDomainOwner, this.roleDomainContext, this.roleServiceName});
        if (this.roleServiceName != null) {
            this.streamClient.subscribeToMicroService("non tenant role sync ", this.roleDomainOwner, this.roleDomainContext, new RepoStreamingReq(Arrays.asList(new RepoStreamingReq.ResourceInfo(Role.class.getName(), "*", null)), Arrays.asList(new RepoStreamingReq.ResourceInfo(Role.class.getName(), "*", null), new RepoStreamingReq.ResourceInfo(Role.class.getName(), "*", PolicyRef.class.getName(), "*", "*"), new RepoStreamingReq.ResourceInfo(Role.class.getName(), "*", PolicyRef.class.getName(), "*", null)))).doOnNext(e -> this.updateCache((StreamEvent)e)).doOnError(err -> log.error("error syncing roles ", err)).subscribe();
            this.tenantProvider.subscribeToTenants("IAMCache").flatMap(tid -> this.streamClient.subscribeToMicroService("tenant " + tid + " role sync", this.roleDomainOwner, this.roleDomainContext, new RepoStreamingReq(Arrays.asList(new RepoStreamingReq.ResourceInfo(Role.class.getName(), "*", tid)), Arrays.asList(new RepoStreamingReq.ResourceInfo(Role.class.getName(), "*", tid))))).doOnNext(e -> this.updateCache((StreamEvent)e)).doOnError(err -> log.error("error syncing roles ", err)).subscribe();
        }
    }

    private void subscribeToMicroService(String domainOwner, String domainContext) {
        this.subscribeToPolicyStatementUpdate(domainOwner, domainContext);
        this.subscribeToPolicyUpdate(domainOwner, domainContext);
    }

    private void subscribeToPolicyStatementUpdate(String domainOwner, String domainContext) {
        this.streamClient.subscribeToMicroService("policy statement sync", domainOwner, domainContext, new RepoStreamingReq(Arrays.asList(new RepoStreamingReq.ResourceInfo(PolicyStatement.class.getName(), "*", null)), Arrays.asList(new RepoStreamingReq.ResourceInfo(PolicyStatement.class.getName(), "*", null)))).doOnNext(e -> this.updateCache((StreamEvent)e)).subscribe();
    }

    private void subscribeToPolicyUpdate(String domainOwner, String domainContext) {
        this.streamClient.subscribeToMicroService("policy sync", domainOwner, domainContext, new RepoStreamingReq(Arrays.asList(new RepoStreamingReq.ResourceInfo(Policy.class.getName(), "*", null)), Arrays.asList(new RepoStreamingReq.ResourceInfo(Policy.class.getName(), "*", null), new RepoStreamingReq.ResourceInfo(Policy.class.getName(), "*", PolicyStatementRef.class.getName(), "*", null)))).doOnNext(e -> this.updateCache((StreamEvent)e)).subscribe();
    }

    public <T> Optional<T> getEntity(String id) {
        return Optional.ofNullable(this.entityCache.get((Object)id));
    }

    public Collection<Policy> listPolicy(String domainOwner, String domainContext) {
        return this.entityCache.values().stream().filter(e -> Policy.class.isInstance(e)).map(e -> (Policy)Policy.class.cast(e)).filter(p -> p.getDomainOwner().equals(domainOwner) && p.getDomainContext().equals(domainContext)).collect(Collectors.toList());
    }

    public Collection<Policy> listPolicy(List<String> policyContext) {
        return this.entityCache.values().stream().filter(e -> Policy.class.isInstance(e)).map(e -> (Policy)Policy.class.cast(e)).filter(p -> p.getPolicyContext() != null && policyContext.contains(p.getPolicyContext())).collect(Collectors.toList());
    }

    public Collection<Policy> getPoliciesFromRole(Role role) {
        return this.entityCache.values().stream().filter(e -> PolicyRef.class.isInstance(e)).map(e -> (PolicyRef)PolicyRef.class.cast(e)).filter(pf -> pf.rootId().equals(role.id())).filter(pf -> {
            boolean exist;
            boolean bl = exist = this.entityCache.get((Object)EntityIdHelper.refIdToId((String)pf.getPolicyRef())) != null;
            if (!exist) {
                log.warn("policy {} not found for role {}, ignoring ....", (Object)EntityIdHelper.refIdToId((String)pf.getPolicyRef()), (Object)role.id());
            }
            return exist;
        }).map(pf -> (Policy)this.entityCache.get((Object)EntityIdHelper.refIdToId((String)pf.getPolicyRef()))).collect(Collectors.toList());
    }

    public Collection<PolicyStatement> getStatementsFromPolicy(Policy policy) {
        return this.entityCache.values().stream().filter(e -> PolicyStatementRef.class.isInstance(e)).map(e -> (PolicyStatementRef)PolicyStatementRef.class.cast(e)).filter(pf -> pf.rootId().equals(policy.id())).filter(pf -> {
            boolean exist;
            boolean bl = exist = this.entityCache.get((Object)EntityIdHelper.refIdToId((String)pf.entityId())) != null;
            if (!exist) {
                log.warn("policy statement {} not found for policy {}, ignoring ....", (Object)EntityIdHelper.refIdToId((String)pf.entityId()), (Object)policy.id());
            }
            return exist;
        }).map(pf -> (PolicyStatement)this.entityCache.get((Object)EntityIdHelper.refIdToId((String)pf.entityId()))).collect(Collectors.toList());
    }

    public Optional<Policy> getPolicyFromName(String fqPolicyName) {
        String[] arr = fqPolicyName.split(":");
        if (arr.length != 3) {
            throw new ValidationErrorException("Invalid fully qualified policy name");
        }
        String domainOwner = arr[0];
        String domainContext = arr[1];
        String policyName = arr[2];
        return this.entityCache.values().stream().filter(e -> Policy.class.isInstance(e)).filter(p -> this.isPolicyMatch(domainOwner, domainContext, policyName, (Policy)Policy.class.cast(p))).findFirst().map(p -> (Policy)p);
    }

    private boolean isPolicyMatch(String domainOwner, String domainContext, String policyName, Policy policy) {
        return policy.getDomainOwner().equals(domainOwner) && policy.getDomainContext().equals(domainContext) && policy.getPolicyName().equals(policyName);
    }

    public void putToInMemoryCache(Entity entity) {
        this.inMemoryEntities.add(entity);
        this.putToCache(entity);
    }

    private void putToCache(Entity entity) {
        Entity old = (Entity)this.entityCache.get((Object)entity.id());
        log.info("synced {} : {}", (Object)entity, (Object)old);
        if (old == null) {
            this.entityCache.put((Object)entity.id(), (Object)entity).subscribe();
        } else if (old.getMeta().getLastSeq() < entity.getMeta().getLastSeq()) {
            this.entityCache.put((Object)entity.id(), (Object)entity).subscribe();
        }
    }

    private void updateCache(StreamEvent event) {
        if (event.getAction() == StreamEvent.Action.REMOVE) {
            this.removeFromCache(((Entity)event.getEvent()).id());
        } else {
            this.putToCache((Entity)event.getEvent());
        }
    }

    private void removeFromCache(String id) {
        Entity e = (Entity)this.entityCache.get((Object)id);
        if (e != null) {
            log.info("entity {} removed from cache.", (Object)e);
        }
        this.entityCache.remove((Object)id).subscribe();
    }

    private Mono syncPolicyReference(Role role) {
        return this.cluster.requestReply(null, this.roleDomainOwner + "/" + this.roleDomainContext + "/" + this.roleServiceName, QueryByIdRequest.builder().withQueryName("ListPolicyRef").withRootId(role.id()).withVersion("v1").withTenantId(role.getTenantId()).withPagingReq(Query.PagingRequest.EMPTY).build()).flatMapIterable(rs -> ((ResultSet)rs).getItems(PolicyRef.class)).doOnNext(e -> this.putToCache((Entity)((PolicyRef)e))).doOnError(err -> log.error("error on list policyRef.{}", err)).retryWhen(RetryUtil.wrap((Retry)Retry.any().exponentialBackoffWithJitter(Duration.ofSeconds(5L), Duration.ofSeconds(60L)))).then();
    }

    private void subscribeToPolicyRef() {
        this.entityCache.flux("IAMCache:PolicyRef").filter(e -> Role.class.isInstance(e.getValue())).filter(e -> e.getType() == FluxMap.Event.Type.ADD || e.getType() == FluxMap.Event.Type.UPDATE).map(e -> (Entity)e.getValue()).filter(e -> !this.inMemoryEntities.contains(e)).doOnNext(e -> log.info("starting to sync policy references for role {}:{}", (Object)e.entityId(), (Object)e.id())).flatMap(r -> this.syncPolicyReference((Role)r)).doOnError(err -> log.error("error on sync  policyRef stream.{}", err)).subscribe();
    }

    private Mono syncPolicyStatementReference(Policy policy) {
        return this.cluster.requestReply(null, policy.getDomainOwner() + "/" + policy.getDomainContext() + "/v1/PolicyQueryService", QueryByIdRequest.builder().withQueryName("ListPolicyStatementRef").withRootId(policy.id()).withVersion("v1").withPagingReq(Query.PagingRequest.EMPTY).build()).doOnNext(e -> log.info("sync policy statement references received for policy {} : {}", (Object)policy.id(), (Object)((ResultSet)ResultSet.class.cast(e)).getItems(PolicyStatementRef.class).size())).flatMapIterable(rs -> ((ResultSet)rs).getItems(PolicyStatementRef.class)).doOnNext(e -> this.putToCache((Entity)((PolicyStatementRef)e))).doOnError(err -> log.error("error on list PolicyStatmentRef.{}", err)).retryWhen(RetryUtil.wrap((Retry)Retry.any().exponentialBackoffWithJitter(Duration.ofSeconds(5L), Duration.ofSeconds(60L)))).then();
    }

    private void subscribeToPolicyStatementRef() {
        this.entityCache.flux("IAMCache:PolicyStatementRef").filter(e -> Policy.class.isInstance(e.getValue())).filter(e -> e.getType() == FluxMap.Event.Type.ADD || e.getType() == FluxMap.Event.Type.UPDATE).map(e -> (Entity)e.getValue()).filter(e -> !this.inMemoryEntities.contains(e)).doOnNext(e -> log.info("starting to sync policy statement references for policy {}:{}", (Object)e.entityId(), (Object)e.id())).flatMap(r -> this.syncPolicyStatementReference((Policy)r)).doOnError(err -> log.error("error on sync  PolicyStatmentRef stream.{}", err)).subscribe();
    }
}

