/*
 * Decompiled with CFR 0.152.
 */
package com.cloudimpl.outstack.spring.util;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.TableCollection;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ConditionCheck;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.Put;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.ReturnValuesOnConditionCheckFailure;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItem;
import com.amazonaws.services.dynamodbv2.model.TransactWriteItemsRequest;
import com.amazonaws.services.dynamodbv2.model.Update;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class App {
    public static void createMapTable(DynamoDB ddb, String tableName, String hashKeyName) {
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        attributeDefinitions.add(new AttributeDefinition().withAttributeName(hashKeyName).withAttributeType("S"));
        ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
        keySchema.add(new KeySchemaElement().withAttributeName(hashKeyName).withKeyType(KeyType.HASH));
        CreateTableRequest request = new CreateTableRequest().withTableName(tableName).withKeySchema(keySchema).withAttributeDefinitions(attributeDefinitions).withProvisionedThroughput(new ProvisionedThroughput().withReadCapacityUnits(Long.valueOf(5L)).withWriteCapacityUnits(Long.valueOf(6L)));
        ddb.createTable(request);
    }

    public static void main(String[] args) {
        Gson gson = new Gson();
        System.out.println(gson.toJson((Object)"Amazon DynamoDB Transaction Sample!"));
        AmazonDynamoDB client = (AmazonDynamoDB)AmazonDynamoDBClientBuilder.standard().build();
        DynamoDB dynamoDB = new DynamoDB(client);
        TableCollection tables = dynamoDB.listTables();
        for (Table table : tables) {
            System.out.println(table.getTableName());
        }
        String CUSTOMER_TABLE_NAME = "Customers";
        String CUSTOMER_PARTITION_KEY = "CustomerId";
        String customerId = "09e8e9c8-ec48";
        HashMap<String, AttributeValue> customerItemKey = new HashMap<String, AttributeValue>();
        customerItemKey.put("CustomerId", new AttributeValue("09e8e9c8-ec48"));
        ConditionCheck checkItem = new ConditionCheck().withTableName("Customers").withKey(customerItemKey).withConditionExpression("attribute_exists(CustomerId)");
        System.out.println(gson.toJson((Object)checkItem));
        String PRODUCT_TABLE_NAME = "ProductCatalog";
        String PRODUCT_PARTITION_KEY = "ProductId";
        String productKey = "aaa-001";
        HashMap<String, AttributeValue> productItemKey = new HashMap<String, AttributeValue>();
        productItemKey.put("ProductId", new AttributeValue("aaa-001"));
        HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
        expressionAttributeValues.put(":new_status", new AttributeValue("SOLD"));
        expressionAttributeValues.put(":expected_status", new AttributeValue("IN_STOCK"));
        Put createProduct = new Put().withTableName("ProductCatalog").withItem(productItemKey).withReturnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.ALL_OLD).withConditionExpression("attribute_not_exists(ProductId)");
        List<TransactWriteItem> actions2 = Arrays.asList(new TransactWriteItem().withPut(createProduct));
        TransactWriteItemsRequest createProductTransaction = new TransactWriteItemsRequest().withTransactItems(actions2).withReturnConsumedCapacity(ReturnConsumedCapacity.TOTAL);
        client.transactWriteItems(createProductTransaction);
        Update markItemSold = new Update().withTableName("ProductCatalog").withKey(productItemKey).withUpdateExpression("SET ProductStatus = :new_status").withExpressionAttributeValues(expressionAttributeValues).withConditionExpression("ProductStatus = :expected_status").withReturnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.ALL_OLD);
        System.out.println(gson.toJson((Object)markItemSold));
        String ORDER_PARTITION_KEY = "OrderId";
        String ORDER_TABLE_NAME = "Orders";
        String orderId = "ord-001";
        HashMap<String, AttributeValue> orderItem = new HashMap<String, AttributeValue>();
        orderItem.put("OrderId", new AttributeValue("ord-001"));
        orderItem.put("ProductId", new AttributeValue("aaa-001"));
        orderItem.put("CustomerId", new AttributeValue("09e8e9c8-ec48"));
        orderItem.put("OrderStatus", new AttributeValue("CONFIRMED"));
        orderItem.put("OrderTotal", new AttributeValue("100"));
        Put createOrder = new Put().withTableName("Orders").withItem(orderItem).withReturnValuesOnConditionCheckFailure(ReturnValuesOnConditionCheckFailure.ALL_OLD).withConditionExpression("attribute_not_exists(OrderId)");
        System.out.println(gson.toJson((Object)createOrder));
        List<TransactWriteItem> actions3 = Arrays.asList(new TransactWriteItem().withConditionCheck(checkItem), new TransactWriteItem().withPut(createOrder), new TransactWriteItem().withUpdate(markItemSold));
        TransactWriteItemsRequest placeOrderTransaction = new TransactWriteItemsRequest().withTransactItems(actions3).withReturnConsumedCapacity(ReturnConsumedCapacity.TOTAL);
        try {
            client.transactWriteItems(placeOrderTransaction);
            System.out.println("Transaction Successful");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

