/*
 * Decompiled with CFR 0.152.
 */
package codacy.api;

import codacy.api.error.CodacyError;
import codacy.api.error.CodacyGenericException;
import codacy.api.request.ApiRequest;
import com.google.gson.Gson;
import java.util.HashMap;

public class CodacyClient {
    private ApiRequest client = null;
    private String apiToken = null;

    public CodacyClient(String string) {
        this(string, "https", "api.codacy.com", 443);
    }

    public CodacyClient(String string, String string2, String string3, int n) {
        this.apiToken = string;
        this.client = new ApiRequest(string2, string3, n);
    }

    public <T> T getRequest(String string, Class<T> clazz) throws CodacyGenericException {
        return this.getRequest(string, clazz, new HashMap<String, String>());
    }

    public <T> T getRequest(String string, Class<T> clazz, HashMap<String, String> hashMap) throws CodacyGenericException {
        return this.genericRequest("GET", string, clazz, hashMap);
    }

    public <T> T postRequest(String string, Class<T> clazz) throws CodacyGenericException {
        return this.postRequest(string, clazz, new HashMap<String, String>());
    }

    public <T> T postRequest(String string, Class<T> clazz, HashMap<String, String> hashMap) throws CodacyGenericException {
        return this.genericRequest("POST", string, clazz, hashMap);
    }

    public <T> T genericRequest(String string, String string2, Class<T> clazz, HashMap<String, String> hashMap) throws CodacyGenericException {
        hashMap.put("api_token", this.apiToken);
        String string3 = null;
        Gson gson = new Gson();
        try {
            string3 = this.client.request(string, string2, hashMap);
            return (T)gson.fromJson(string3, clazz);
        }
        catch (Exception exception) {
            throw this.handleException(string3, exception);
        }
    }

    private CodacyGenericException handleException(String string, Exception exception) {
        Gson gson = new Gson();
        String string2 = string;
        if (string == null || string.isEmpty()) {
            string2 = exception.getMessage();
        }
        try {
            CodacyError codacyError = (CodacyError)gson.fromJson(string2, CodacyError.class);
            return new CodacyGenericException(codacyError.getError());
        }
        catch (Exception exception2) {
            return new CodacyGenericException(exception.getMessage(), exception);
        }
    }
}

