/*
 * Decompiled with CFR 0.152.
 */
package codacy.api.util;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLHelper {
    public static void loadCerts() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, KeyManagementException, IOException, URISyntaxException {
        ClassLoader classLoader = SSLHelper.class.getClassLoader();
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certs = certFactory.generateCertificates(classLoader.getResourceAsStream("startssl.pem"));
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        certs.iterator().forEachRemaining(cert -> {
            try {
                keyStore.setCertificateEntry(UUID.randomUUID().toString(), (Certificate)cert);
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
        });
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        TrustManager[] trustManager = tmf.getTrustManagers();
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, trustManager, new SecureRandom());
        SSLSocketFactory sslFactory = context.getSocketFactory();
        HttpsURLConnection.setDefaultSSLSocketFactory(sslFactory);
    }
}

