/*
 * Decompiled with CFR 0.152.
 */
package com.codedx.client.api;

import com.codedx.client.ApiCallback;
import com.codedx.client.ApiClient;
import com.codedx.client.ApiException;
import com.codedx.client.ApiResponse;
import com.codedx.client.Configuration;
import com.codedx.client.Pair;
import com.codedx.client.ProgressRequestBody;
import com.codedx.client.ProgressResponseBody;
import com.codedx.client.model.GenerateReport;
import com.codedx.client.model.Job;
import com.codedx.client.model.ReportType;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ReportingApi {
    private ApiClient apiClient;

    public ReportingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ReportingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call generateReportCall(Integer n, String string, GenerateReport generateReport, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        GenerateReport generateReport2 = generateReport;
        String string2 = "/api/projects/{project-id}/report/{report-type}".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString())).replaceAll("\\{report-type\\}", this.apiClient.escapeString(string.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string3 = this.apiClient.selectHeaderAccept(stringArray);
        if (string3 != null) {
            hashMap.put("Accept", string3);
        }
        String[] stringArray2 = new String[]{"application/json"};
        String string4 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string4);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string2, "POST", arrayList, arrayList2, generateReport2, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call generateReportValidateBeforeCall(Integer n, String string, GenerateReport generateReport, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling generateReport(Async)");
        }
        if (string == null) {
            throw new ApiException("Missing the required parameter 'reportType' when calling generateReport(Async)");
        }
        if (generateReport == null) {
            throw new ApiException("Missing the required parameter 'body' when calling generateReport(Async)");
        }
        Call call = this.generateReportCall(n, string, generateReport, progressListener, progressRequestListener);
        return call;
    }

    public Job generateReport(Integer n, String string, GenerateReport generateReport) throws ApiException {
        ApiResponse<Job> apiResponse = this.generateReportWithHttpInfo(n, string, generateReport);
        return apiResponse.getData();
    }

    public ApiResponse<Job> generateReportWithHttpInfo(Integer n, String string, GenerateReport generateReport) throws ApiException {
        Call call = this.generateReportValidateBeforeCall(n, string, generateReport, null, null);
        Type type = new TypeToken<Job>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call generateReportAsync(Integer n, String string, GenerateReport generateReport, final ApiCallback<Job> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.generateReportValidateBeforeCall(n, string, generateReport, progressListener, progressRequestListener);
        Type type = new TypeToken<Job>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }

    public Call getReportTypesCall(Integer n, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object var4_4 = null;
        String string = "/api/projects/{project-id}/report/types".replaceAll("\\{project-id\\}", this.apiClient.escapeString(n.toString()));
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        String[] stringArray = new String[]{"application/json"};
        String string2 = this.apiClient.selectHeaderAccept(stringArray);
        if (string2 != null) {
            hashMap.put("Accept", string2);
        }
        String[] stringArray2 = new String[]{};
        String string3 = this.apiClient.selectHeaderContentType(stringArray2);
        hashMap.put("Content-Type", string3);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response response = chain.proceed(chain.request());
                    return response.newBuilder().body((ResponseBody)new ProgressResponseBody(response.body(), progressListener)).build();
                }
            });
        }
        String[] stringArray3 = new String[]{"APIKeyHeader", "basicAuth"};
        return this.apiClient.buildCall(string, "GET", arrayList, arrayList2, var4_4, hashMap, hashMap2, stringArray3, progressRequestListener);
    }

    private Call getReportTypesValidateBeforeCall(Integer n, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (n == null) {
            throw new ApiException("Missing the required parameter 'projectId' when calling getReportTypes(Async)");
        }
        Call call = this.getReportTypesCall(n, progressListener, progressRequestListener);
        return call;
    }

    public Map<String, ReportType> getReportTypes(Integer n) throws ApiException {
        ApiResponse<Map<String, ReportType>> apiResponse = this.getReportTypesWithHttpInfo(n);
        return apiResponse.getData();
    }

    public ApiResponse<Map<String, ReportType>> getReportTypesWithHttpInfo(Integer n) throws ApiException {
        Call call = this.getReportTypesValidateBeforeCall(n, null, null);
        Type type = new TypeToken<Map<String, ReportType>>(){}.getType();
        return this.apiClient.execute(call, type);
    }

    public Call getReportTypesAsync(Integer n, final ApiCallback<Map<String, ReportType>> apiCallback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (apiCallback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long l, long l2, boolean bl) {
                    apiCallback.onDownloadProgress(l, l2, bl);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long l, long l2, boolean bl) {
                    apiCallback.onUploadProgress(l, l2, bl);
                }
            };
        }
        Call call = this.getReportTypesValidateBeforeCall(n, progressListener, progressRequestListener);
        Type type = new TypeToken<Map<String, ReportType>>(){}.getType();
        this.apiClient.executeAsync(call, type, apiCallback);
        return call;
    }
}

