/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.test.runner;

import com.codingapi.test.annotation.DBType;
import com.codingapi.test.annotation.XmlBuild;
import com.codingapi.test.config.TestConfig;
import com.codingapi.test.utils.SqlUtils;
import com.codingapi.test.xml.XmlInfo;
import com.codingapi.test.xml.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.atteo.classindex.ClassIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConditionalOnProperty(name={"codingapi.test.mode"})
public class XmlBuildRunner
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(XmlBuildRunner.class);
    @Autowired
    private TestConfig testConfig;

    public void run(String ... args) throws IOException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        String outPath = this.testConfig.getOutPath();
        Iterable annotated = ClassIndex.getAnnotated(XmlBuild.class);
        Iterator iterator = annotated.iterator();
        if (this.testConfig.getMode().equals((Object)TestConfig.Mode.OFF)) {
            return;
        }
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            XmlBuild xmlBuild = clazz.getAnnotation(XmlBuild.class);
            String filePath = outPath + "/" + xmlBuild.name() + ".xml";
            XmlInfo xmlInfo = new XmlInfo();
            xmlInfo.setName(xmlBuild.name());
            xmlInfo.setClassName(clazz.getName());
            xmlInfo.setDbType(xmlBuild.dbType());
            if (StringUtils.isEmpty((Object)xmlBuild.initCmd()) && xmlBuild.dbType().equals((Object)DBType.RELATIONAL)) {
                String sql = SqlUtils.createInsertSql(xmlBuild.name(), xmlBuild.colType(), clazz);
                xmlInfo.setInitCmd(sql);
            } else {
                xmlInfo.setInitCmd(xmlBuild.initCmd());
            }
            Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            xmlInfo.getList().add(obj);
            File file = new File(filePath);
            if (this.testConfig.getMode().equals((Object)TestConfig.Mode.Addition) && file.exists()) {
                return;
            }
            String content = XmlUtils.create(xmlInfo);
            log.info("file:{},content->{}", (Object)file, (Object)content);
            FileUtils.writeStringToFile((File)file, (String)content);
        }
    }
}

