package com.darkrockstudios.texteditor.utils

import kotlin.contracts.ExperimentalContracts
import kotlin.contracts.contract

@OptIn(ExperimentalContracts::class)
internal inline fun <R> fastMapRange(
	start: Int,
	end: Int,
	transform: (Int) -> R
): List<R> {
	contract { callsInPlace(transform) }
	val destination = ArrayList<R>(/* initialCapacity = */ end - start + 1)
	for (i in start..end) {
		destination.add(transform(i))
	}
	return destination
}