/*
 * Decompiled with CFR 0.152.
 */
package com.deep007.mitmproxyjava.mitmproxy;

import com.deep007.mitmproxyjava.MitmproxyStartRequest;
import com.deep007.mitmproxyjava.MitmproxyStartResponse;
import com.deep007.mitmproxyjava.MitmproxyStopRequest;
import com.deep007.mitmproxyjava.VoidResponse;
import com.deep007.mitmproxyjava.filter.Cookie;
import com.deep007.mitmproxyjava.filter.CookieCollectFilter;
import com.deep007.mitmproxyjava.filter.FlowFilter;
import com.deep007.mitmproxyjava.grpc.MitmProxyHubServerGrpc;
import com.deep007.mitmproxyjava.grpc.MitmproxyFlowCallBackServer;
import com.deep007.mitmproxyjava.modle.FlowRequest;
import com.deep007.mitmproxyjava.modle.FlowResponse;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RemoteMitmproxy {
    public static final Map<String, RemoteMitmproxy> RemoteMitmproxies = new ConcurrentHashMap<String, RemoteMitmproxy>();
    private String mitmproxyHubAddr;
    private int mitmproxyHubPort;
    private String remoteBind;
    private int remoteBindPort;
    private volatile String mitmproxyId;
    private MitmProxyHubServerGrpc.MitmProxyHubServerBlockingStub mitmProxyHubServerBlockingStub;
    private List<FlowFilter> filters = new ArrayList<FlowFilter>();

    public RemoteMitmproxy(String mitmproxyHubAddr, int mitmproxyHubPort, String remoteBind, int remoteBindPort) {
        this.mitmproxyHubAddr = mitmproxyHubAddr;
        this.mitmproxyHubPort = mitmproxyHubPort;
        this.remoteBind = remoteBind;
        this.remoteBindPort = remoteBindPort;
    }

    public synchronized void start() {
        if (this.mitmproxyId == null) {
            MitmproxyFlowCallBackServer mitmproxyFlowCallBackServer = MitmproxyFlowCallBackServer.getInstance();
            MitmproxyStartRequest request = MitmproxyStartRequest.newBuilder().setBind(this.remoteBind).setPort(this.remoteBindPort).setCallbackServerAddr("127.0.0.1").setCallbackServerPort(mitmproxyFlowCallBackServer.port).build();
            ManagedChannel channel = ManagedChannelBuilder.forAddress((String)this.mitmproxyHubAddr, (int)this.mitmproxyHubPort).usePlaintext().build();
            this.mitmProxyHubServerBlockingStub = MitmProxyHubServerGrpc.newBlockingStub((Channel)channel);
            MitmproxyStartResponse response = this.mitmProxyHubServerBlockingStub.start(request);
            this.mitmproxyId = response.getMitmproxyId();
            RemoteMitmproxies.put(this.mitmproxyId, this);
        }
    }

    public void addFlowFilter(FlowFilter flowFilter) {
        this.filters.add(flowFilter);
    }

    public boolean isRunning() {
        return this.mitmproxyId != null;
    }

    public void stop() {
        if (this.isRunning()) {
            try {
                MitmproxyStopRequest request = MitmproxyStopRequest.newBuilder().setMitmproxyId(this.mitmproxyId).build();
                VoidResponse voidResponse = this.mitmProxyHubServerBlockingStub.stop(request);
            }
            catch (Exception exception) {
                // empty catch block
            }
            RemoteMitmproxies.remove(this.mitmproxyId);
        }
    }

    public void onRequest(FlowRequest flowRequest) {
        for (FlowFilter flowFilter : this.filters) {
            flowFilter.filterRequest(flowRequest);
        }
    }

    public void onResponse(FlowResponse flowResponse) {
        for (FlowFilter flowFilter : this.filters) {
            flowFilter.filterResponse(flowResponse);
        }
    }

    public String getRemoteBind() {
        return this.remoteBind;
    }

    public int getRemoteBindPort() {
        return this.remoteBindPort;
    }

    public static void main(String[] args) throws InterruptedException {
        RemoteMitmproxy remoteMitmproxy = new RemoteMitmproxy("127.0.0.1", 60051, "127.0.0.1", 8866);
        CookieCollectFilter cookieCollectFilter = new CookieCollectFilter();
        remoteMitmproxy.addFlowFilter(cookieCollectFilter);
        remoteMitmproxy.addFlowFilter(new FlowFilter(){

            @Override
            public void filterResponse(FlowResponse flowResponse) {
                flowResponse.getHeaders().remove("Server");
            }

            @Override
            public void filterRequest(FlowRequest flowRequest) {
                flowRequest.getHeaders().remove("User-Agent");
                flowRequest.getHeaders().remove("Accept");
            }
        });
        remoteMitmproxy.start();
        Thread.sleep(30000L);
        remoteMitmproxy.stop();
        for (Cookie cookie : cookieCollectFilter.catchCookies) {
            System.out.println(cookie.getDomain() + ">>>" + cookie.getName() + "=" + cookie.getValue() + " path:" + cookie.getPath());
        }
    }
}

