/*
 * Decompiled with CFR 0.152.
 */
package com.deep007.mitmproxyjava.modle;

import com.deep007.mitmproxyjava.MitmResponse;
import com.deep007.mitmproxyjava.modle.FlowHeaders;
import com.deep007.mitmproxyjava.modle.FlowRequest;
import com.google.protobuf.ByteString;
import java.nio.charset.Charset;
import java.util.Map;

public final class FlowResponse {
    public static final String CLASS_NAME = FlowResponse.class.getName();
    private final FlowRequest request;
    private final FlowHeaders headers;
    private byte[] content;
    private int statusCode;

    public static final FlowResponse create(MitmResponse response) {
        FlowHeaders headers = new FlowHeaders(response.getHeadersList());
        byte[] content = null;
        if (response.getContent() != null) {
            content = response.getContent().toByteArray();
        }
        FlowRequest request = FlowRequest.create(response.getRequest());
        return new FlowResponse(request, headers, content, response.getStatusCode());
    }

    public final MitmResponse getMitmResponse() {
        MitmResponse.Builder builder = MitmResponse.newBuilder().setStatusCode(this.statusCode).addAllHeaders(this.headers.getMitmHeaders()).setRequest(this.request.getMitmRequest());
        if (this.content != null) {
            builder.setContent(ByteString.copyFrom((byte[])this.content));
        }
        return builder.build();
    }

    public FlowResponse(FlowRequest request, FlowHeaders headers, byte[] content, int statusCode) {
        this.request = request;
        this.headers = headers;
        this.content = content;
        this.statusCode = statusCode;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public FlowRequest getRequest() {
        return this.request;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getContentAsString() {
        if (this.content == null) {
            return null;
        }
        return this.getContentAsString(Charset.forName("UTF-8"));
    }

    public String getContentAsString(Charset charset) {
        if (this.content == null) {
            return null;
        }
        return new String(this.content, charset);
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public void setContentAsString(String content) {
        this.content = content.getBytes(Charset.forName("UTF-8"));
    }

    public void setContentAsString(String content, Charset charset) {
        this.content = content.getBytes(charset);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(String name) {
        return (String)this.headers.get(name);
    }
}

