/*
 * Decompiled with CFR 0.152.
 */
package com.deep007.mitmproxyjava.filter;

import com.deep007.mitmproxyjava.filter.Cookie;
import com.deep007.mitmproxyjava.filter.FlowFilter;
import com.deep007.mitmproxyjava.modle.FlowRequest;
import com.deep007.mitmproxyjava.modle.FlowResponse;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CookieCollectFilter
implements FlowFilter {
    private Pattern SETCOOKIE_NAME_VALUE_MATCHER = Pattern.compile("([^\\s]+)=([^\\s,;]+)");
    private Pattern URL_DOMAIN_MATCHER = Pattern.compile("http[s]?://([^\\.]+[^/]+)");
    public Map<String, Cookie> catchCookies = new ConcurrentHashMap<String, Cookie>();

    public String domainFromUrl(String url) {
        Matcher sendcookie_domain_matcher = this.URL_DOMAIN_MATCHER.matcher(url);
        if (!sendcookie_domain_matcher.find()) {
            System.err.println("\u4eceurl\u89e3\u6790domain\u5931\u8d25:" + url);
            return "baidu.com";
        }
        return sendcookie_domain_matcher.group(1);
    }

    @Override
    public void filterRequest(FlowRequest flowRequest) {
        String sendCookie = flowRequest.getHeaders().get("Cookie");
        if (sendCookie == null || sendCookie.isEmpty()) {
            return;
        }
        String url = flowRequest.getUrl();
        String domain = this.domainFromUrl(url);
        String[] items = sendCookie.split(";");
        for (int i = 0; items != null && i < items.length; ++i) {
            String item = items[i].trim();
            if (item.contains("=")) {
                String[] nameValue = item.split("=", 2);
                Cookie cookie = new Cookie(nameValue[0], nameValue[1]);
                cookie.setDomain(domain);
                this.catchCookies.put(nameValue[0], cookie);
                continue;
            }
            if (item.isEmpty()) continue;
        }
    }

    @Override
    public void filterResponse(FlowResponse flowResponse) {
        String setCookie = flowResponse.getHeader("Set-Cookie");
        if (setCookie == null || setCookie.isEmpty()) {
            return;
        }
        String url = flowResponse.getRequest().getUrl();
        String domain = this.domainFromUrl(url);
        Matcher setcookie_name_value_matcher = this.SETCOOKIE_NAME_VALUE_MATCHER.matcher(setCookie.trim());
        while (setcookie_name_value_matcher.find()) {
            String name = setcookie_name_value_matcher.group(1);
            if (name.equalsIgnoreCase("path") || name.equalsIgnoreCase("domain") || name.equalsIgnoreCase("expires") || name.equalsIgnoreCase("Max-Age")) continue;
            String value = setcookie_name_value_matcher.group(2);
            Cookie cookie = new Cookie(name, value);
            cookie.setDomain(domain);
            this.catchCookies.put(name, cookie);
        }
    }
}

