/*
 * Decompiled with CFR 0.152.
 */
package com.deep007.mitmproxyjava.filter;

import com.deep007.mitmproxyjava.filter.Cookie;
import com.deep007.mitmproxyjava.filter.FlowFilter;
import com.deep007.mitmproxyjava.modle.FlowRequest;
import com.deep007.mitmproxyjava.modle.FlowResponse;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CookieCollectFilter
implements FlowFilter {
    private Pattern SETCOOKIE_NAME_VALUE_MATCHER = Pattern.compile("^([^=]+)=([^;]*)");
    private Pattern SETCOOKIE_DOMAIN_MATCHER = Pattern.compile("[dD]{1}omain=([^;]+)");
    private Pattern SENDCOOKIE_DOMAIN_MATCHER = Pattern.compile("http[s]?://[^\\.]+([^/]+)");
    public Set<Cookie> catchCookies = new HashSet<Cookie>();

    public synchronized boolean containsCookie(String name) {
        for (Cookie cookie : this.catchCookies) {
            if (!cookie.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private void extractCookies(String sendCookie, String domain) {
        String[] items = sendCookie.split(";");
        for (int i = 0; items != null && i < items.length; ++i) {
            String item = items[i].trim();
            if (item.contains("=")) {
                String[] nameValue = item.split("=", 2);
                if (this.containsCookie(nameValue[0])) continue;
                Cookie cookie = new Cookie(nameValue[0], nameValue[1]);
                cookie.setDomain(domain);
                this.catchCookies.add(cookie);
                continue;
            }
            if (item.isEmpty()) continue;
        }
    }

    @Override
    public void filterRequest(FlowRequest flowRequest) {
        String sendCookie = flowRequest.getHeaders().get("Cookie");
        if (sendCookie == null || sendCookie.isEmpty()) {
            return;
        }
        String url = flowRequest.getUrl();
        Matcher sendcookie_domain_matcher = this.SENDCOOKIE_DOMAIN_MATCHER.matcher(url);
        if (!sendcookie_domain_matcher.find()) {
            return;
        }
        String domain = sendcookie_domain_matcher.group(1);
        this.extractCookies(sendCookie, domain);
    }

    @Override
    public void filterResponse(FlowResponse flowResponse) {
        String setCookie = flowResponse.getHeader("Set-Cookie");
        if (setCookie == null || setCookie.isEmpty()) {
            return;
        }
        String url = flowResponse.getRequest().getUrl();
        Matcher setdcookie_domain_matcher = this.SENDCOOKIE_DOMAIN_MATCHER.matcher(url);
        if (!setdcookie_domain_matcher.find()) {
            return;
        }
        String domain = setdcookie_domain_matcher.group(1);
        Matcher setcookie_name_value_matcher = this.SETCOOKIE_NAME_VALUE_MATCHER.matcher(setCookie.trim());
        Matcher setcookie_domain_matcher = this.SETCOOKIE_DOMAIN_MATCHER.matcher(setCookie);
        if (setcookie_name_value_matcher.find()) {
            Cookie cookie = new Cookie(setcookie_name_value_matcher.group(1), setcookie_name_value_matcher.group(2));
            if (setcookie_domain_matcher.find()) {
                cookie.setDomain(setcookie_domain_matcher.group(1));
            } else {
                cookie.setDomain(domain);
            }
            cookie.setHttpOnly(setCookie.contains("HttpOnly") || setCookie.contains("httpOnly"));
            this.catchCookies.add(cookie);
        } else {
            System.err.println("setCookie\u89e3\u6790\u9519\u8bef:" + setCookie);
        }
    }
}

