/*
 * Decompiled with CFR 0.152.
 */
package com.deftlabs.lock.mongo;

import com.deftlabs.lock.mongo.DistributedLock;
import com.deftlabs.lock.mongo.DistributedLockSvc;
import com.deftlabs.lock.mongo.DistributedLockSvcFactory;
import com.deftlabs.lock.mongo.DistributedLockSvcOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoURI;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class DistributedLockIntTests {
    private final Mongo _mongo = new Mongo(new MongoURI("mongodb://127.0.0.1:27017"));

    @Test
    public void testSimpleCreate() throws Exception {
        Assert.assertNotNull((Object)this.createSimpleLockSvc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleLockCreateDestroy() throws Exception {
        DistributedLockSvc lockSvc = this.createSimpleLockSvc();
        try {
            DistributedLock lock = null;
            try {
                lock = lockSvc.create("testLock");
            }
            finally {
                if (lock != null) {
                    lockSvc.destroy(lock);
                }
            }
        }
        finally {
            lockSvc.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleLockCreateLockUnlockDestroy() throws Exception {
        DistributedLockSvc lockSvc = this.createSimpleLockSvc();
        try {
            DistributedLock lock = null;
            try {
                lock = lockSvc.create("testLock");
                try {
                    lock.lock();
                }
                finally {
                    lock.unlock();
                }
            }
            finally {
                if (lock != null) {
                    lockSvc.destroy(lock);
                }
            }
        }
        finally {
            lockSvc.shutdown();
        }
        Assert.assertEquals((long)2L, (long)this.getHistoryCollection().count());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleLockWithNestedTryLock() throws Exception {
        DistributedLockSvc lockSvc = this.createSimpleLockSvc();
        try {
            DistributedLock lock = null;
            try {
                lock = lockSvc.create("testLock");
                try {
                    lock.lock();
                    Assert.assertEquals((Object)false, (Object)lock.tryLock());
                }
                finally {
                    lock.unlock();
                }
            }
            finally {
                if (lock != null) {
                    lockSvc.destroy(lock);
                }
            }
        }
        finally {
            lockSvc.shutdown();
        }
        Assert.assertEquals((long)2L, (long)this.getHistoryCollection().count());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleTryLock() throws Exception {
        DistributedLockSvc lockSvc = this.createSimpleLockSvc();
        try {
            DistributedLock lock = null;
            try {
                lock = lockSvc.create("testLock");
                try {
                    lock.tryLock();
                }
                finally {
                    lock.unlock();
                }
            }
            finally {
                if (lock != null) {
                    lockSvc.destroy(lock);
                }
            }
        }
        finally {
            lockSvc.shutdown();
        }
        Assert.assertEquals((long)2L, (long)this.getHistoryCollection().count());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleTimedTryLock() throws Exception {
        DistributedLockSvc lockSvc = this.createSimpleLockSvc();
        try {
            DistributedLock lock = null;
            try {
                lock = lockSvc.create("testLock");
                try {
                    Assert.assertEquals((Object)true, (Object)lock.tryLock(0L, TimeUnit.SECONDS));
                }
                finally {
                    lock.unlock();
                }
            }
            finally {
                if (lock != null) {
                    lockSvc.destroy(lock);
                }
            }
        }
        finally {
            lockSvc.shutdown();
        }
        Assert.assertEquals((long)2L, (long)this.getHistoryCollection().count());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleTimedTryLock2() throws Exception {
        DistributedLockSvc lockSvc = this.createSimpleLockSvc();
        try {
            DistributedLock lock = null;
            try {
                lock = lockSvc.create("testLock");
                try {
                    lock.lock();
                    Assert.assertEquals((Object)false, (Object)lock.tryLock(0L, TimeUnit.SECONDS));
                }
                finally {
                    lock.unlock();
                }
            }
            finally {
                if (lock != null) {
                    lockSvc.destroy(lock);
                }
            }
        }
        finally {
            lockSvc.shutdown();
        }
        Assert.assertEquals((long)2L, (long)this.getHistoryCollection().count());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleTimedTryLock3() throws Exception {
        DistributedLockSvc lockSvc = this.createSimpleLockSvc();
        try {
            DistributedLock lock = null;
            try {
                lock = lockSvc.create("testLock");
                try {
                    lock.lock();
                    long startTime = System.currentTimeMillis();
                    Assert.assertEquals((Object)false, (Object)lock.tryLock(1L, TimeUnit.SECONDS));
                    long blockTime = System.currentTimeMillis() - startTime;
                    long diff = blockTime - 1000L;
                    Assert.assertEquals((Object)true, (Object)(diff <= 5L ? 1 : 0));
                }
                finally {
                    lock.unlock();
                }
            }
            finally {
                if (lock != null) {
                    lockSvc.destroy(lock);
                }
            }
        }
        finally {
            lockSvc.shutdown();
        }
        Assert.assertEquals((long)2L, (long)this.getHistoryCollection().count());
    }

    private DistributedLockSvc createSimpleLockSvc() {
        DistributedLockSvcOptions options = new DistributedLockSvcOptions("mongodb://127.0.0.1:27017");
        DistributedLockSvcFactory factory = new DistributedLockSvcFactory(options);
        return factory.getLockSvc();
    }

    @Before
    public void init() throws Exception {
        this.getCollection().remove((DBObject)new BasicDBObject());
        this.getHistoryCollection().remove((DBObject)new BasicDBObject());
    }

    @After
    public void cleanup() {
        this.getCollection().remove((DBObject)new BasicDBObject());
    }

    private DBCollection getCollection() {
        return this._mongo.getDB("mongo-distributed-lock").getCollection("locks");
    }

    private DBCollection getHistoryCollection() {
        return this._mongo.getDB("mongo-distributed-lock").getCollection("lockHistory");
    }
}

