/*
 * Decompiled with CFR 0.152.
 */
package com.deftlabs.lock.mongo.impl;

import com.deftlabs.lock.mongo.DistributedLock;
import com.deftlabs.lock.mongo.DistributedLockOptions;
import com.deftlabs.lock.mongo.DistributedLockSvcOptions;
import com.deftlabs.lock.mongo.impl.LockDao;
import com.mongodb.Mongo;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import org.bson.types.ObjectId;

public class LockImpl
implements DistributedLock {
    private final String _name;
    private final Mongo _mongo;
    private final DistributedLockOptions _lockOptions;
    private final DistributedLockSvcOptions _svcOptions;
    private volatile ObjectId _lockId;
    private final AtomicBoolean _locked = new AtomicBoolean(false);
    private final AtomicBoolean _running = new AtomicBoolean(false);
    private final Queue<Thread> _waitingThreads = new ConcurrentLinkedQueue<Thread>();

    LockImpl(Mongo pMongo, String pName, DistributedLockOptions pLockOptions, DistributedLockSvcOptions pSvcOptions) {
        this._mongo = pMongo;
        this._name = pName;
        this._lockOptions = pLockOptions;
        this._svcOptions = pSvcOptions;
    }

    public void lock() {
        if (this.tryDistributedLock()) {
            return;
        }
        this.park();
    }

    private void park() {
        boolean wasInterrupted = false;
        Thread current = Thread.currentThread();
        this._waitingThreads.add(current);
        while (this._running.get()) {
            LockSupport.park(this);
            if (Thread.interrupted()) {
                wasInterrupted = true;
                break;
            }
            if (this._waitingThreads.peek() != current || this.isLocked() || !this.tryDistributedLock()) continue;
        }
        if (wasInterrupted) {
            current.interrupt();
        } else {
            this._waitingThreads.remove();
        }
    }

    private boolean park(long pNanos) {
        boolean wasInterrupted = false;
        Thread current = Thread.currentThread();
        this._waitingThreads.add(current);
        boolean locked = false;
        long parkTime = pNanos;
        long startTime = System.nanoTime();
        while (this._running.get() && (parkTime = pNanos - (System.nanoTime() - startTime)) > 0L) {
            LockSupport.parkNanos(this, parkTime);
            if (Thread.interrupted()) {
                wasInterrupted = true;
                break;
            }
            if (this._waitingThreads.peek() != current || this.isLocked() || !this.tryDistributedLock()) continue;
            locked = true;
            break;
        }
        this._waitingThreads.remove();
        if (wasInterrupted) {
            current.interrupt();
            return locked;
        }
        return locked;
    }

    private boolean tryDistributedLock() {
        if (this.isLocked()) {
            return false;
        }
        ObjectId lockId = LockDao.lock(this._mongo, this._name, this._svcOptions, this._lockOptions);
        if (lockId == null) {
            return false;
        }
        this._locked.set(true);
        this._lockId = lockId;
        return true;
    }

    public void lockInterruptibly() {
        throw new UnsupportedOperationException("not implemented");
    }

    public Condition newCondition() {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean tryLock() {
        if (this.isLocked()) {
            return false;
        }
        ObjectId lockId = LockDao.lock(this._mongo, this._name, this._svcOptions, this._lockOptions);
        if (lockId == null) {
            return false;
        }
        this._locked.set(true);
        this._lockId = lockId;
        return true;
    }

    public boolean tryLock(long pTime, TimeUnit pTimeUnit) {
        if (this.tryDistributedLock()) {
            return true;
        }
        return this.park(pTimeUnit.toNanos(pTime));
    }

    public void unlock() {
        LockDao.unlock(this._mongo, this._name, this._svcOptions, this._lockOptions, this._lockId);
        this._locked.set(false);
        this._lockId = null;
        LockSupport.unpark(this._waitingThreads.peek());
    }

    synchronized void init() {
        if (this._running.get()) {
            throw new IllegalStateException("init already called");
        }
        this._running.set(true);
    }

    synchronized void destroy() {
        if (!this._running.get()) {
            throw new IllegalStateException("destroy already called");
        }
        this._running.set(false);
        for (Thread t : this._waitingThreads) {
            t.interrupt();
        }
        this._waitingThreads.clear();
    }

    public boolean isLocked() {
        return this._locked.get();
    }

    public String getName() {
        return this._name;
    }

    public ObjectId getLockId() {
        return this._lockId;
    }

    public DistributedLockOptions getOptions() {
        return this._lockOptions;
    }
}

