/*
 * Decompiled with CFR 0.152.
 */
package com.deftlabs.lock.mongo.impl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum LockState {
    LOCKED("locked"),
    UNLOCKED("unlocked");

    private final String _code;

    private LockState(String pCode) {
        this._code = pCode;
    }

    public String code() {
        return this._code;
    }

    public boolean isLocked() {
        return this == LOCKED;
    }

    public boolean isUnlocked() {
        return this == UNLOCKED;
    }

    public static LockState findByCode(String pCode) {
        if (pCode == null) {
            throw new IllegalArgumentException("Invalid lock state code: " + pCode);
        }
        for (LockState s : LockState.values()) {
            if (!s._code.equals(pCode)) continue;
            return s;
        }
        throw new IllegalArgumentException("Invalid lock state code: " + pCode);
    }
}

