/*
 * Decompiled with CFR 0.152.
 */
package com.deftlabs.lock.mongo.impl;

import com.deftlabs.lock.mongo.DistributedLock;
import com.deftlabs.lock.mongo.DistributedLockSvcOptions;
import com.deftlabs.lock.mongo.impl.LockDao;
import com.mongodb.Mongo;
import java.util.Map;
import org.bson.types.ObjectId;

final class Monitor {
    Monitor() {
    }

    static class LockTimeout
    implements Runnable {
        private static final long CHECK_FREQUENCY = 60000L;
        private volatile boolean _running = true;
        private final Mongo _mongo;
        private final DistributedLockSvcOptions _svcOptions;

        public void run() {
            while (this._running) {
                try {
                    LockDao.expireInactiveLocks(this._mongo, this._svcOptions);
                    Thread.sleep(60000L);
                }
                catch (InterruptedException ie) {
                    break;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        LockTimeout(Mongo pMongo, DistributedLockSvcOptions pSvcOptions) {
            this._mongo = pMongo;
            this._svcOptions = pSvcOptions;
        }

        void stopRunning() {
            this._running = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LockHeartbeat
    implements Runnable {
        private static final long HEARTBEAT_FREQUENCY = 5000L;
        private volatile boolean _running = true;
        private final Mongo _mongo;
        private final DistributedLockSvcOptions _svcOptions;
        private final Map<String, DistributedLock> _locks;

        @Override
        public void run() {
            while (this._running) {
                try {
                    for (String lockName : this._locks.keySet()) {
                        DistributedLock lock = this._locks.get(lockName);
                        ObjectId lockId = lock.getLockId();
                        if (!lock.isLocked() || lockId == null) continue;
                        LockDao.heartbeat(this._mongo, lockName, lockId, lock.getOptions(), this._svcOptions);
                    }
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ie) {
                    break;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        LockHeartbeat(Mongo pMongo, DistributedLockSvcOptions pSvcOptions, Map<String, DistributedLock> pLocks) {
            this._mongo = pMongo;
            this._svcOptions = pSvcOptions;
            this._locks = pLocks;
        }

        void stopRunning() {
            this._running = false;
        }
    }
}

