/*
 * Decompiled with CFR 0.152.
 */
package com.deftlabs.lock.mongo;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class DistributedLockSvcOptions {
    private final String _mongoUri;
    private final String _dbName;
    private final String _collectionName;
    private String _historyCollectionName = "lockHistory";
    private String _hostname;
    private String _hostAddress;
    private final String _appName;
    private static final String LIB_VERSION = "0.1.4";
    private boolean _enableHistory = true;
    private boolean _historyIsCapped = true;
    private long _historySize = 0xC800000L;

    public DistributedLockSvcOptions(String pMongoUri) {
        this(pMongoUri, "mongo-distributed-lock", "locks", null);
    }

    public DistributedLockSvcOptions(String pMongoUri, String pDbName, String pCollectionName) {
        this(pMongoUri, pDbName, pCollectionName, null);
    }

    public DistributedLockSvcOptions(String pMongoUri, String pDbName, String pCollectionName, String pAppName) {
        this._mongoUri = pMongoUri;
        this._dbName = pDbName;
        this._collectionName = pCollectionName;
        this._appName = pAppName;
        try {
            this._hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            this._hostAddress = null;
        }
        try {
            this._hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this._hostname = null;
        }
    }

    public String getMongoUri() {
        return this._mongoUri;
    }

    public String getDbName() {
        return this._dbName;
    }

    public String getCollectionName() {
        return this._collectionName;
    }

    public String getAppName() {
        return this._appName;
    }

    public void setEnableHistory(boolean pV) {
        this._enableHistory = pV;
    }

    public boolean getEnableHistory() {
        return this._enableHistory;
    }

    public void setHistoryIsCapped(boolean pV) {
        this._historyIsCapped = pV;
    }

    public boolean getHistoryIsCapped() {
        return this._historyIsCapped;
    }

    public void setHistorySize(long pV) {
        this._historySize = pV;
    }

    public long getHistorySize() {
        return this._historySize;
    }

    public String getLibVersion() {
        return LIB_VERSION;
    }

    public String getHostname() {
        return this._hostname;
    }

    public void setHostname(String pV) {
        this._hostname = pV;
    }

    public String getHostAddress() {
        return this._hostAddress;
    }

    public void setHistoryCollectionName(String pV) {
        this._historyCollectionName = pV;
    }

    public String getHistoryCollectionName() {
        return this._historyCollectionName;
    }
}

