/*
 * Decompiled with CFR 0.152.
 */
package com.deftlabs.lock.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoURI;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class DriverIntTests {
    private final Mongo _mongo = new Mongo(new MongoURI("mongodb://127.0.0.1:27017"));

    @Test
    public void testWriteConcerns() throws Exception {
        BasicDBObject doc = new BasicDBObject("_id", (Object)"test");
        this.getDb().requestStart();
        this.getCollection().insert((DBObject)doc, WriteConcern.NORMAL);
        WriteResult result = this.getCollection().insert((DBObject)doc, WriteConcern.NORMAL);
        CommandResult cmdResult = result.getLastError(WriteConcern.NORMAL);
        Assert.assertTrue((cmdResult.getException() != null ? 1 : 0) != 0);
        this.getDb().requestDone();
    }

    @Test
    public void testFindAndModify() throws Exception {
        BasicDBObject query = new BasicDBObject("_id", (Object)"test");
        BasicDBObject toSet = new BasicDBObject("locked", (Object)true);
        BasicDBObject lockDoc = (BasicDBObject)this.getCollection().findAndModify((DBObject)query, (DBObject)new BasicDBObject("_id", (Object)1), null, false, (DBObject)new BasicDBObject("$set", (Object)toSet), false, false);
        Assert.assertNull((Object)lockDoc);
    }

    @Test
    public void testFindAndModifyWithDoc() throws Exception {
        BasicDBObject insert = new BasicDBObject("_id", (Object)"test");
        insert.put("locked", (Object)false);
        insert.put("lockId", (Object)"10");
        this.getCollection().insert((DBObject)insert, WriteConcern.SAFE);
        BasicDBObject query = new BasicDBObject("_id", (Object)"test");
        query.put("locked", (Object)false);
        query.put("lockId", (Object)"10");
        BasicDBObject toSet = new BasicDBObject("locked", (Object)true);
        toSet.put("lockId", (Object)"20");
        BasicDBObject lockDoc = (BasicDBObject)this.getCollection().findAndModify((DBObject)query, (DBObject)new BasicDBObject("lockId", (Object)1), null, false, (DBObject)new BasicDBObject("$set", (Object)toSet), true, false);
        Assert.assertNotNull((Object)lockDoc);
        Assert.assertEquals((Object)"20", (Object)lockDoc.getString("lockId"));
    }

    @Test
    public void testFindAndModifyWithDocMiss() throws Exception {
        BasicDBObject insert = new BasicDBObject("_id", (Object)"test");
        insert.put("locked", (Object)false);
        insert.put("lockId", (Object)"10");
        this.getCollection().insert((DBObject)insert, WriteConcern.SAFE);
        BasicDBObject query = new BasicDBObject("_id", (Object)"test");
        query.put("locked", (Object)false);
        query.put("lockId", (Object)"20");
        BasicDBObject toSet = new BasicDBObject("locked", (Object)true);
        toSet.put("lockId", (Object)"20");
        BasicDBObject lockDoc = (BasicDBObject)this.getCollection().findAndModify((DBObject)query, (DBObject)new BasicDBObject("lockId", (Object)1), null, false, (DBObject)new BasicDBObject("$set", (Object)toSet), true, false);
        Assert.assertNull((Object)lockDoc);
    }

    @Before
    public void init() throws Exception {
        this.getDb().dropDatabase();
    }

    @After
    public void cleanup() {
        this.getDb().dropDatabase();
    }

    private DBCollection getCollection() {
        return this.getDb().getCollection("test");
    }

    private DB getDb() {
        return this._mongo.getDB("mongo-distributed-lock-test");
    }
}

