/*
 * Decompiled with CFR 0.152.
 */
package com.deftlabs.lock.mongo.impl;

import com.deftlabs.lock.mongo.DistributedLockSvcOptions;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import java.util.Date;

abstract class BaseDao {
    protected static final String INC = "$inc";
    protected static final String SET = "$set";
    protected static final String LT = "$lt";
    private static final String LOCAL_TIME_FIELD = "localTime";
    private static final int SERVER_TIME_TRIES = 3;
    protected static final int DUPLICATE_KEY_ERROR_CODE = 11000;
    protected static final BasicDBObject _serverStatusCmd = new BasicDBObject("serverStatus", (Object)1);

    BaseDao() {
    }

    protected static final void requestStart(Mongo pMongo, DistributedLockSvcOptions pSvcOptions) {
        BaseDao.getDb(pMongo, pSvcOptions).requestStart();
    }

    protected static final void requestDone(Mongo pMongo, DistributedLockSvcOptions pSvcOptions) {
        BaseDao.getDb(pMongo, pSvcOptions).requestDone();
    }

    protected static final DB getDb(Mongo pMongo, DistributedLockSvcOptions pSvcOptions) {
        return pMongo.getDB(pSvcOptions.getDbName());
    }

    protected static final long getServerTime(Mongo pMongo, DistributedLockSvcOptions pSvcOptions) {
        long[] localTimes = new long[3];
        int[] latency = new int[3];
        for (int idx = 0; idx < 3; ++idx) {
            long startTime = System.currentTimeMillis();
            CommandResult serverStatus = BaseDao.getDb(pMongo, pSvcOptions).command((DBObject)_serverStatusCmd);
            latency[idx] = (int)(System.currentTimeMillis() - startTime);
            localTimes[idx] = ((Date)serverStatus.get(LOCAL_TIME_FIELD)).getTime();
        }
        long serverTime = localTimes[2];
        return serverTime + (long)BaseDao.getHalfRoundedAvg(latency);
    }

    protected static final int getHalfRoundedAvg(int[] pV) {
        int total = 0;
        for (int idx = 0; idx < pV.length; ++idx) {
            total += pV[idx];
        }
        return Math.round((float)total / (float)pV.length / 2.0f);
    }
}

