/*
 * Decompiled with CFR 0.152.
 */
package com.deftlabs.lock.mongo.impl;

import com.deftlabs.lock.mongo.DistributedLockOptions;
import com.deftlabs.lock.mongo.DistributedLockSvcOptions;
import com.deftlabs.lock.mongo.impl.BaseDao;
import com.deftlabs.lock.mongo.impl.LockDef;
import com.deftlabs.lock.mongo.impl.LockHistoryDao;
import com.deftlabs.lock.mongo.impl.LockState;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.util.Date;
import org.bson.types.ObjectId;

final class LockDao
extends BaseDao {
    LockDao() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void heartbeat(Mongo pMongo, String pLockName, ObjectId pLockId, DistributedLockOptions pLockOptions, DistributedLockSvcOptions pSvcOptions) {
        try {
            LockDao.requestStart(pMongo, pSvcOptions);
            long serverTime = LockDao.getServerTime(pMongo, pSvcOptions);
            BasicDBObject query = new BasicDBObject(LockDef.ID.field, (Object)pLockName);
            query.put(LockDef.LOCK_ID.field, (Object)pLockId);
            query.put(LockDef.STATE.field, (Object)LockState.LOCKED.code());
            BasicDBObject toSet = new BasicDBObject(LockDef.LAST_HEARTBEAT.field, (Object)new Date(serverTime));
            toSet.put(LockDef.LOCK_TIMEOUT_TIME.field, (Object)new Date(serverTime + (long)pLockOptions.getInactiveLockTimeout()));
            LockDao.getDbCollection(pMongo, pSvcOptions).update((DBObject)query, (DBObject)new BasicDBObject("$set", (Object)toSet), false, false);
        }
        finally {
            LockDao.requestDone(pMongo, pSvcOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized ObjectId lock(Mongo pMongo, String pLockName, DistributedLockSvcOptions pSvcOptions, DistributedLockOptions pLockOptions) {
        try {
            ObjectId lockId;
            ObjectId lockId2;
            LockDao.requestStart(pMongo, pSvcOptions);
            BasicDBObject lockDoc = LockDao.findById(pMongo, pLockName, pSvcOptions);
            long serverTime = LockDao.getServerTime(pMongo, pSvcOptions);
            long startTime = System.currentTimeMillis();
            if (lockDoc == null && (lockId2 = LockDao.tryInsertNew(pMongo, pLockName, pSvcOptions, pLockOptions, serverTime, startTime)) != null) {
                ObjectId objectId = lockId2;
                return objectId;
            }
            if (lockDoc == null) {
                lockDoc = LockDao.findById(pMongo, pLockName, pSvcOptions);
            }
            LockState lockState = LockState.findByCode(lockDoc.getString(LockDef.STATE.field));
            ObjectId currentLockId = lockDoc.getObjectId(LockDef.LOCK_ID.field);
            if (lockState.isUnlocked() && (lockId = LockDao.tryLockingExisting(pMongo, pLockName, currentLockId, pSvcOptions, pLockOptions, serverTime, startTime)) != null) {
                ObjectId objectId = lockId;
                return objectId;
            }
            lockId = (ObjectId)lockDoc.get(LockDef.LOCK_ID.field);
            LockDao.incrementLockAttemptCount(pMongo, pLockName, lockId, pSvcOptions);
            ObjectId objectId = null;
            return objectId;
        }
        finally {
            LockDao.requestDone(pMongo, pSvcOptions);
        }
    }

    private static ObjectId tryLockingExisting(Mongo pMongo, String pLockName, ObjectId pCurrentLockId, DistributedLockSvcOptions pSvcOptions, DistributedLockOptions pLockOptions, long pServerTime, long pStartTime) {
        long adjustTime = System.currentTimeMillis() - pStartTime;
        long serverTime = pServerTime + adjustTime;
        Date now = new Date(serverTime);
        ObjectId lockId = ObjectId.get();
        BasicDBObject query = new BasicDBObject(LockDef.ID.field, (Object)pLockName);
        query.put(LockDef.LOCK_ID.field, (Object)pCurrentLockId);
        query.put(LockDef.STATE.field, (Object)LockState.UNLOCKED.code());
        BasicDBObject toSet = new BasicDBObject();
        toSet.put(LockDef.LIBRARY_VERSION.field, (Object)pSvcOptions.getLibVersion());
        toSet.put(LockDef.UPDATED.field, (Object)now);
        toSet.put(LockDef.LAST_HEARTBEAT.field, (Object)now);
        toSet.put(LockDef.LOCK_ACQUIRED_TIME.field, (Object)now);
        toSet.put(LockDef.LOCK_TIMEOUT_TIME.field, (Object)new Date(serverTime + (long)pLockOptions.getInactiveLockTimeout()));
        toSet.put(LockDef.LOCK_ID.field, (Object)lockId);
        toSet.put(LockDef.STATE.field, (Object)LockState.LOCKED.code());
        toSet.put(LockDef.OWNER_APP_NAME.field, (Object)pSvcOptions.getAppName());
        toSet.put(LockDef.OWNER_ADDRESS.field, (Object)pSvcOptions.getHostAddress());
        toSet.put(LockDef.OWNER_HOSTNAME.field, (Object)pSvcOptions.getHostname());
        toSet.put(LockDef.OWNER_THREAD_ID.field, (Object)Thread.currentThread().getId());
        toSet.put(LockDef.OWNER_THREAD_NAME.field, (Object)Thread.currentThread().getName());
        toSet.put(LockDef.OWNER_THREAD_GROUP_NAME.field, (Object)Thread.currentThread().getThreadGroup().getName());
        toSet.put(LockDef.LOCK_ATTEMPT_COUNT.field, (Object)0);
        toSet.put(LockDef.INACTIVE_LOCK_TIMEOUT.field, (Object)pLockOptions.getInactiveLockTimeout());
        BasicDBObject lockDoc = (BasicDBObject)LockDao.getDbCollection(pMongo, pSvcOptions).findAndModify((DBObject)query, (DBObject)new BasicDBObject(LockDef.LOCK_ID.field, (Object)1), null, false, (DBObject)new BasicDBObject("$set", (Object)toSet), true, false);
        if (lockDoc == null) {
            return null;
        }
        if (!lockDoc.containsField(LockDef.LOCK_ID.field)) {
            return null;
        }
        ObjectId returnedLockId = lockDoc.getObjectId(LockDef.LOCK_ID.field);
        if (returnedLockId == null) {
            return null;
        }
        if (!returnedLockId.equals((Object)lockId)) {
            return null;
        }
        if (pSvcOptions.getEnableHistory()) {
            LockHistoryDao.insert(pMongo, pLockName, pSvcOptions, pLockOptions, serverTime, LockState.LOCKED, (Object)lockId, false);
        }
        return lockId;
    }

    private static ObjectId tryInsertNew(Mongo pMongo, String pLockName, DistributedLockSvcOptions pSvcOptions, DistributedLockOptions pLockOptions, long pServerTime, long pStartTime) {
        long adjustTime = System.currentTimeMillis() - pStartTime;
        long serverTime = pServerTime + adjustTime;
        Date now = new Date(serverTime);
        ObjectId lockId = ObjectId.get();
        Thread currentThread = Thread.currentThread();
        BasicDBObject lockDoc = new BasicDBObject(LockDef.ID.field, (Object)pLockName);
        lockDoc.put(LockDef.LIBRARY_VERSION.field, (Object)pSvcOptions.getLibVersion());
        lockDoc.put(LockDef.UPDATED.field, (Object)now);
        lockDoc.put(LockDef.LAST_HEARTBEAT.field, (Object)now);
        lockDoc.put(LockDef.LOCK_ACQUIRED_TIME.field, (Object)now);
        lockDoc.put(LockDef.LOCK_ID.field, (Object)lockId);
        lockDoc.put(LockDef.STATE.field, (Object)LockState.LOCKED.code());
        lockDoc.put(LockDef.LOCK_TIMEOUT_TIME.field, (Object)new Date(serverTime + (long)pLockOptions.getInactiveLockTimeout()));
        lockDoc.put(LockDef.OWNER_APP_NAME.field, (Object)pSvcOptions.getAppName());
        lockDoc.put(LockDef.OWNER_ADDRESS.field, (Object)pSvcOptions.getHostAddress());
        lockDoc.put(LockDef.OWNER_HOSTNAME.field, (Object)pSvcOptions.getHostname());
        lockDoc.put(LockDef.OWNER_THREAD_ID.field, (Object)currentThread.getId());
        lockDoc.put(LockDef.OWNER_THREAD_NAME.field, (Object)currentThread.getName());
        lockDoc.put(LockDef.OWNER_THREAD_GROUP_NAME.field, (Object)currentThread.getThreadGroup().getName());
        lockDoc.put(LockDef.LOCK_ATTEMPT_COUNT.field, (Object)0);
        lockDoc.put(LockDef.INACTIVE_LOCK_TIMEOUT.field, (Object)pLockOptions.getInactiveLockTimeout());
        WriteResult result = LockDao.getDbCollection(pMongo, pSvcOptions).insert((DBObject)lockDoc, WriteConcern.NORMAL);
        CommandResult cmdResult = result.getLastError(WriteConcern.NORMAL);
        if (!cmdResult.ok() || cmdResult.getException() != null || cmdResult.getErrorMessage() != null) {
            return null;
        }
        if (pSvcOptions.getEnableHistory()) {
            LockHistoryDao.insert(pMongo, pLockName, pSvcOptions, pLockOptions, serverTime, LockState.LOCKED, (Object)lockId, false);
        }
        return lockId;
    }

    static boolean isLocked(Mongo pMongo, String pLockName, DistributedLockSvcOptions pSvcOptions) {
        BasicDBObject lock = (BasicDBObject)LockDao.getDbCollection(pMongo, pSvcOptions).findOne((DBObject)new BasicDBObject(LockDef.ID.field, (Object)pLockName), (DBObject)new BasicDBObject(LockDef.STATE.field, (Object)1));
        if (lock == null) {
            return false;
        }
        LockState state = LockState.findByCode(lock.getString(LockDef.STATE.field));
        return state.isLocked();
    }

    static BasicDBObject findById(Mongo pMongo, String pLockName, DistributedLockSvcOptions pSvcOptions) {
        return (BasicDBObject)LockDao.getDbCollection(pMongo, pSvcOptions).findOne((DBObject)new BasicDBObject(LockDef.ID.field, (Object)pLockName));
    }

    static void incrementLockAttemptCount(Mongo pMongo, String pLockName, ObjectId pLockId, DistributedLockSvcOptions pSvcOptions) {
        BasicDBObject query = new BasicDBObject(LockDef.ID.field, (Object)pLockName);
        query.put(LockDef.LOCK_ID.field, (Object)pLockId);
        LockDao.getDbCollection(pMongo, pSvcOptions).update((DBObject)query, (DBObject)new BasicDBObject("$inc", (Object)new BasicDBObject(LockDef.LOCK_ATTEMPT_COUNT.field, (Object)1)), false, false);
    }

    static synchronized void unlock(Mongo pMongo, String pLockName, DistributedLockSvcOptions pSvcOptions, DistributedLockOptions pLockOptions, ObjectId pLockId) {
        BasicDBObject toSet = new BasicDBObject();
        toSet.put(LockDef.LIBRARY_VERSION.field, null);
        toSet.put(LockDef.UPDATED.field, (Object)new Date(LockDao.getServerTime(pMongo, pSvcOptions)));
        toSet.put(LockDef.LOCK_ACQUIRED_TIME.field, null);
        toSet.put(LockDef.LOCK_TIMEOUT_TIME.field, null);
        toSet.put(LockDef.LOCK_ID.field, null);
        toSet.put(LockDef.STATE.field, (Object)LockState.UNLOCKED.code());
        toSet.put(LockDef.OWNER_APP_NAME.field, null);
        toSet.put(LockDef.OWNER_ADDRESS.field, null);
        toSet.put(LockDef.OWNER_HOSTNAME.field, null);
        toSet.put(LockDef.OWNER_THREAD_ID.field, null);
        toSet.put(LockDef.OWNER_THREAD_NAME.field, null);
        toSet.put(LockDef.OWNER_THREAD_GROUP_NAME.field, null);
        toSet.put(LockDef.LOCK_ATTEMPT_COUNT.field, (Object)0);
        toSet.put(LockDef.INACTIVE_LOCK_TIMEOUT.field, null);
        BasicDBObject query = new BasicDBObject(LockDef.ID.field, (Object)pLockName);
        query.put(LockDef.LOCK_ID.field, (Object)pLockId);
        query.put(LockDef.STATE.field, (Object)LockState.LOCKED.code());
        LockDao.getDbCollection(pMongo, pSvcOptions).findAndModify((DBObject)query, null, null, false, (DBObject)new BasicDBObject("$set", (Object)toSet), false, false);
        if (pSvcOptions.getEnableHistory()) {
            LockHistoryDao.insert(pMongo, pLockName, pSvcOptions, pLockOptions, 0L, LockState.UNLOCKED, (Object)pLockId, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void expireInactiveLocks(Mongo pMongo, DistributedLockSvcOptions pSvcOptions) {
        long queryServerTime = LockDao.getServerTime(pMongo, pSvcOptions);
        BasicDBObject query = new BasicDBObject(LockDef.STATE.field, (Object)LockState.LOCKED.code());
        query.put(LockDef.LOCK_TIMEOUT_TIME.field, (Object)new BasicDBObject("$lt", (Object)new Date(queryServerTime)));
        DBCursor cur = LockDao.getDbCollection(pMongo, pSvcOptions).find((DBObject)query).batchSize(10);
        try {
            while (cur.hasNext()) {
                BasicDBObject lockDoc = (BasicDBObject)cur.next();
                ObjectId lockId = (ObjectId)lockDoc.get(LockDef.LOCK_ID.field);
                String lockName = lockDoc.getString(LockDef.ID.field);
                long serverTime = LockDao.getServerTime(pMongo, pSvcOptions);
                BasicDBObject toSet = new BasicDBObject();
                toSet.put(LockDef.LIBRARY_VERSION.field, null);
                toSet.put(LockDef.UPDATED.field, (Object)new Date(serverTime));
                toSet.put(LockDef.LOCK_ACQUIRED_TIME.field, null);
                toSet.put(LockDef.LOCK_TIMEOUT_TIME.field, null);
                toSet.put(LockDef.LOCK_ID.field, null);
                toSet.put(LockDef.STATE.field, (Object)LockState.UNLOCKED.code());
                toSet.put(LockDef.OWNER_APP_NAME.field, null);
                toSet.put(LockDef.OWNER_ADDRESS.field, null);
                toSet.put(LockDef.OWNER_HOSTNAME.field, null);
                toSet.put(LockDef.OWNER_THREAD_ID.field, null);
                toSet.put(LockDef.OWNER_THREAD_NAME.field, null);
                toSet.put(LockDef.OWNER_THREAD_GROUP_NAME.field, null);
                toSet.put(LockDef.LOCK_ATTEMPT_COUNT.field, (Object)0);
                toSet.put(LockDef.INACTIVE_LOCK_TIMEOUT.field, null);
                BasicDBObject timeoutQuery = new BasicDBObject(LockDef.ID.field, (Object)lockName);
                timeoutQuery.put(LockDef.LOCK_ID.field, (Object)lockId);
                timeoutQuery.put(LockDef.STATE.field, (Object)LockState.LOCKED.code());
                timeoutQuery.put(LockDef.LOCK_TIMEOUT_TIME.field, (Object)new BasicDBObject("$lt", (Object)new Date(serverTime)));
                BasicDBObject previousLockDoc = (BasicDBObject)LockDao.getDbCollection(pMongo, pSvcOptions).findAndModify((DBObject)timeoutQuery, (DBObject)new BasicDBObject(LockDef.INACTIVE_LOCK_TIMEOUT.field, (Object)1), null, false, (DBObject)new BasicDBObject("$set", (Object)toSet), false, false);
                if (previousLockDoc == null || !pSvcOptions.getEnableHistory()) continue;
                LockHistoryDao.insert(pMongo, lockName, pSvcOptions, previousLockDoc.getInt(LockDef.INACTIVE_LOCK_TIMEOUT.field), serverTime, LockState.LOCKED, (Object)lockId, true);
            }
        }
        finally {
            if (cur != null) {
                cur.close();
            }
        }
    }

    private static DBCollection getDbCollection(Mongo pMongo, DistributedLockSvcOptions pSvcOptions) {
        return LockDao.getDb(pMongo, pSvcOptions).getCollection(pSvcOptions.getCollectionName());
    }

    static void setup(Mongo pMongo, DistributedLockSvcOptions pSvcOptions) {
        LockDao.getDbCollection(pMongo, pSvcOptions).ensureIndex((DBObject)new BasicDBObject(LockDef.LAST_HEARTBEAT.field, (Object)1), "lastHeartbeatV1Idx", false);
        LockDao.getDbCollection(pMongo, pSvcOptions).ensureIndex((DBObject)new BasicDBObject(LockDef.OWNER_APP_NAME.field, (Object)1), "ownerAppNameV1Idx", false);
        LockDao.getDbCollection(pMongo, pSvcOptions).ensureIndex((DBObject)new BasicDBObject(LockDef.STATE.field, (Object)1), "stateV1Idx", false);
        LockDao.getDbCollection(pMongo, pSvcOptions).ensureIndex((DBObject)new BasicDBObject(LockDef.LOCK_ID.field, (Object)1), "lockIdV1Idx", false);
        BasicDBObject idStateIdx = new BasicDBObject(LockDef.ID.field, (Object)1);
        idStateIdx.put(LockDef.STATE.field, (Object)1);
        LockDao.getDbCollection(pMongo, pSvcOptions).ensureIndex((DBObject)idStateIdx, "idStateV1Idx", false);
        BasicDBObject idLockIdIdx = new BasicDBObject(LockDef.ID.field, (Object)1);
        idStateIdx.put(LockDef.LOCK_ID.field, (Object)1);
        LockDao.getDbCollection(pMongo, pSvcOptions).ensureIndex((DBObject)idLockIdIdx, "idLockIdV1Idx", false);
        BasicDBObject stateTimeoutIdx = new BasicDBObject(LockDef.STATE.field, (Object)1);
        stateTimeoutIdx.put(LockDef.LOCK_TIMEOUT_TIME.field, (Object)1);
        LockDao.getDbCollection(pMongo, pSvcOptions).ensureIndex((DBObject)stateTimeoutIdx, "stateTimeoutV1Idx", false);
        BasicDBObject idStateLockIdIdx = new BasicDBObject(LockDef.ID.field, (Object)1);
        idStateLockIdIdx.put(LockDef.LOCK_ID.field, (Object)1);
        idStateLockIdIdx.put(LockDef.STATE.field, (Object)1);
        LockDao.getDbCollection(pMongo, pSvcOptions).ensureIndex((DBObject)idStateLockIdIdx, "idStateLockIdV1Idx", false);
        BasicDBObject idStateLockIdTimeoutIdx = new BasicDBObject(LockDef.ID.field, (Object)1);
        idStateLockIdTimeoutIdx.put(LockDef.LOCK_ID.field, (Object)1);
        idStateLockIdTimeoutIdx.put(LockDef.STATE.field, (Object)1);
        idStateLockIdTimeoutIdx.put(LockDef.LOCK_TIMEOUT_TIME.field, (Object)1);
        LockDao.getDbCollection(pMongo, pSvcOptions).ensureIndex((DBObject)idStateLockIdTimeoutIdx, "idStateLockIdTimeoutV1Idx", false);
    }
}

