/*
 * Decompiled with CFR 0.152.
 */
package com.deftlabs.lock.mongo.impl;

import com.deftlabs.lock.mongo.DistributedLock;
import com.deftlabs.lock.mongo.DistributedLockException;
import com.deftlabs.lock.mongo.DistributedLockOptions;
import com.deftlabs.lock.mongo.DistributedLockSvc;
import com.deftlabs.lock.mongo.DistributedLockSvcOptions;
import com.deftlabs.lock.mongo.impl.LockDao;
import com.deftlabs.lock.mongo.impl.LockHistoryDao;
import com.deftlabs.lock.mongo.impl.LockImpl;
import com.deftlabs.lock.mongo.impl.Monitor;
import com.mongodb.Mongo;
import com.mongodb.MongoURI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public final class SvcImpl
implements DistributedLockSvc {
    private Mongo _mongo;
    private final ReentrantLock _lock = new ReentrantLock(true);
    private final DistributedLockSvcOptions _options;
    private final AtomicBoolean _running = new AtomicBoolean(false);
    private Monitor.LockHeartbeat _lockHeartbeat;
    private Monitor.LockTimeout _lockTimeout;
    private Monitor.LockUnlocked _lockUnlocked;
    private final Map<String, DistributedLock> _locks = new ConcurrentHashMap<String, DistributedLock>();

    public SvcImpl(DistributedLockSvcOptions pOptions) {
        this._options = pOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedLock create(String pLockName, DistributedLockOptions pLockOptions) {
        try {
            this._lock.lock();
            if (this._locks.containsKey(pLockName)) {
                DistributedLock distributedLock = this._locks.get(pLockName);
                return distributedLock;
            }
            LockImpl lock = new LockImpl(this._mongo, pLockName, pLockOptions, this._options);
            lock.init();
            this._locks.put(pLockName, lock);
            LockImpl lockImpl = lock;
            return lockImpl;
        }
        finally {
            this._lock.unlock();
        }
    }

    public DistributedLock create(String pLockName) {
        return this.create(pLockName, new DistributedLockOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(DistributedLock pLock) {
        try {
            this._lock.lock();
            if (!this._locks.containsKey(pLock.getName())) {
                throw new DistributedLockException("Lock has already been destroyed: " + pLock.getName());
            }
            if (pLock.isLocked()) {
                throw new IllegalStateException("Lock is currently in use - must unlock before destroying");
            }
            try {
                ((LockImpl)pLock).destroy();
            }
            finally {
                this._locks.remove(pLock.getName());
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    public void startup() {
        this._running.set(true);
        try {
            this._lock.lock();
            this._mongo = new Mongo(new MongoURI(this._options.getMongoUri()));
            LockDao.setup(this._mongo, this._options);
            if (this._options.getEnableHistory()) {
                LockHistoryDao.setup(this._mongo, this._options);
            }
            this._lockHeartbeat = new Monitor.LockHeartbeat(this._mongo, this._options, this._locks);
            new Thread(this._lockHeartbeat).start();
            this._lockTimeout = new Monitor.LockTimeout(this._mongo, this._options);
            new Thread(this._lockTimeout).start();
            this._lockUnlocked = new Monitor.LockUnlocked(this._mongo, this._options, this._locks);
            new Thread(this._lockUnlocked).start();
        }
        catch (Throwable t) {
            throw new DistributedLockException(t);
        }
        finally {
            this._lock.unlock();
        }
    }

    public void shutdown() {
        if (!this._running.get()) {
            throw new IllegalStateException("shutdown called but not running");
        }
        this._running.set(false);
        try {
            this._lock.lock();
            for (String lockName : this._locks.keySet()) {
                DistributedLock lock = this._locks.get(lockName);
                if (lock == null) continue;
                ((LockImpl)lock).destroy();
            }
            this._lockTimeout.stopRunning();
            this._lockHeartbeat.stopRunning();
            this._lockUnlocked.stopRunning();
        }
        catch (Throwable t) {
            throw new DistributedLockException(t);
        }
        finally {
            this._lock.unlock();
        }
    }

    public boolean isRunning() {
        return this._running.get();
    }
}

