/*
 * Decompiled with CFR 0.152.
 */
package com.deftlabs.lock.mongo;

import com.deftlabs.lock.mongo.DistributedLock;
import com.deftlabs.lock.mongo.DistributedLockSvc;
import com.deftlabs.lock.mongo.DistributedLockSvcFactory;
import com.deftlabs.lock.mongo.DistributedLockSvcOptions;
import com.mongodb.DBCollection;
import com.mongodb.Mongo;
import com.mongodb.MongoURI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public final class StandaloneThreadLockTests {
    private static final int THREAD_COUNT = 200;
    private static final int LOCK_TEST_COUNT = 50;
    private final Mongo _mongo = new Mongo(new MongoURI("mongodb://127.0.0.1:27017"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test() throws Exception {
        CountDownLatch countDownLatch = new CountDownLatch(200);
        AtomicBoolean locked = new AtomicBoolean(false);
        DistributedLockSvc lockSvc = this.createSimpleLockSvc();
        try {
            for (int idx = 0; idx < 200; ++idx) {
                new Thread(new LockTest(countDownLatch, lockSvc, locked)).start();
            }
            countDownLatch.await();
        }
        finally {
            lockSvc.shutdown();
        }
    }

    private DistributedLockSvc createSimpleLockSvc() {
        DistributedLockSvcOptions options = new DistributedLockSvcOptions("mongodb://127.0.0.1:27017");
        options.setEnableHistory(false);
        DistributedLockSvcFactory factory = new DistributedLockSvcFactory(options);
        return factory.getLockSvc();
    }

    private DBCollection getCollection() {
        return this._mongo.getDB("mongo-distributed-lock").getCollection("locks");
    }

    private DBCollection getHistoryCollection() {
        return this._mongo.getDB("mongo-distributed-lock").getCollection("lockHistory");
    }

    private StandaloneThreadLockTests() throws Exception {
    }

    public static void main(String[] pArgs) throws Exception {
        StandaloneThreadLockTests tests = new StandaloneThreadLockTests();
        tests.test();
    }

    private static class LockTest
    implements Runnable {
        private final DistributedLockSvc _lockSvc;
        private final CountDownLatch _countDownLatch;
        private final AtomicBoolean _locked;

        private LockTest(CountDownLatch pCountDownLatch, DistributedLockSvc pLockSvc, AtomicBoolean pLocked) {
            this._countDownLatch = pCountDownLatch;
            this._lockSvc = pLockSvc;
            this._locked = pLocked;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DistributedLock lock = this._lockSvc.create("com.deftlabs.lock.mongo.testLock");
            long startTime = System.currentTimeMillis();
            for (int idx = 0; idx < 50; ++idx) {
                try {
                    lock.lock();
                    if (this._locked.compareAndSet(false, true)) continue;
                    throw new IllegalStateException("Already locked");
                }
                finally {
                    if (!this._locked.compareAndSet(true, false)) {
                        throw new IllegalStateException("Already unlocked");
                    }
                    lock.unlock();
                }
            }
            long execTime = System.currentTimeMillis() - startTime;
            this._countDownLatch.countDown();
        }
    }
}

