/*
 * Decompiled with CFR 0.152.
 */
package com.deftlabs.lock.mongo.impl;

import com.deftlabs.lock.mongo.DistributedLockOptions;
import com.deftlabs.lock.mongo.DistributedLockSvcOptions;
import com.deftlabs.lock.mongo.impl.BaseDao;
import com.deftlabs.lock.mongo.impl.LockHistoryDef;
import com.deftlabs.lock.mongo.impl.LockState;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.WriteConcern;
import java.util.Date;

final class LockHistoryDao
extends BaseDao {
    LockHistoryDao() {
    }

    static void insert(Mongo pMongo, String pLockName, DistributedLockSvcOptions pSvcOptions, DistributedLockOptions pLockOptions, long pServerTime, LockState pLockState, Object pLockId, boolean pTimedOut) {
        LockHistoryDao.insert(pMongo, pLockName, pSvcOptions, pLockOptions.getInactiveLockTimeout(), pServerTime, pLockState, pLockId, pTimedOut);
    }

    static void insert(Mongo pMongo, String pLockName, DistributedLockSvcOptions pSvcOptions, int pInactiveLockTimeout, long pServerTime, LockState pLockState, Object pLockId, boolean pTimedOut) {
        Thread currentThread = Thread.currentThread();
        long serverTime = pServerTime;
        if (serverTime == 0L) {
            serverTime = LockHistoryDao.getServerTime(pMongo, pSvcOptions);
        }
        Date now = new Date(serverTime);
        BasicDBObject lockDoc = new BasicDBObject(LockHistoryDef.LOCK_NAME.field, (Object)pLockName);
        lockDoc.put(LockHistoryDef.LIBRARY_VERSION.field, (Object)pSvcOptions.getLibVersion());
        lockDoc.put(LockHistoryDef.CREATED.field, (Object)now);
        lockDoc.put(LockHistoryDef.LOCK_ID.field, pLockId);
        lockDoc.put(LockHistoryDef.STATE.field, (Object)pLockState.code());
        lockDoc.put(LockHistoryDef.OWNER_APP_NAME.field, (Object)pSvcOptions.getAppName());
        lockDoc.put(LockHistoryDef.OWNER_ADDRESS.field, (Object)pSvcOptions.getHostAddress());
        lockDoc.put(LockHistoryDef.OWNER_HOSTNAME.field, (Object)pSvcOptions.getHostname());
        lockDoc.put(LockHistoryDef.OWNER_THREAD_ID.field, (Object)currentThread.getId());
        lockDoc.put(LockHistoryDef.OWNER_THREAD_NAME.field, (Object)currentThread.getName());
        lockDoc.put(LockHistoryDef.OWNER_THREAD_GROUP_NAME.field, (Object)currentThread.getThreadGroup().getName());
        lockDoc.put(LockHistoryDef.INACTIVE_LOCK_TIMEOUT.field, (Object)pInactiveLockTimeout);
        lockDoc.put(LockHistoryDef.TIMED_OUT.field, (Object)pTimedOut);
        LockHistoryDao.getDbCollection(pMongo, pSvcOptions).insert((DBObject)lockDoc, WriteConcern.SAFE);
    }

    private static DBCollection getDbCollection(Mongo pMongo, DistributedLockSvcOptions pSvcOptions) {
        return LockHistoryDao.getDb(pMongo, pSvcOptions).getCollection(pSvcOptions.getHistoryCollectionName());
    }

    static void setup(Mongo pMongo, DistributedLockSvcOptions pSvcOptions) {
    }
}

