/*
 * Decompiled with CFR 0.152.
 */
package com.deftlabs.lock.mongo.impl;

import com.deftlabs.lock.mongo.DistributedLock;
import com.deftlabs.lock.mongo.DistributedLockSvcOptions;
import com.deftlabs.lock.mongo.impl.LockDao;
import com.mongodb.Mongo;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.types.ObjectId;

final class Monitor {
    private static final Logger LOG = Logger.getLogger("com.deftlabs.lock.mongo.Monitor");

    Monitor() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MonitorThread
    extends Thread {
        final Mongo _mongo;
        final DistributedLockSvcOptions _svcOptions;
        final Map<String, DistributedLock> _locks;
        final CountDownLatch _shutdown;
        final CountDownLatch _exited;

        MonitorThread(String pName, Mongo pMongo, DistributedLockSvcOptions pSvcOptions) {
            this(pName, pMongo, pSvcOptions, null);
        }

        MonitorThread(String pName, Mongo pMongo, DistributedLockSvcOptions pSvcOptions, Map<String, DistributedLock> pLocks) {
            super(pName);
            this._mongo = pMongo;
            this._svcOptions = pSvcOptions;
            this._locks = pLocks;
            this._shutdown = new CountDownLatch(1);
            this._exited = new CountDownLatch(1);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean shutdown = false;
            try {
                while (!shutdown) {
                    try {
                        shutdown = this.monitor();
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                    catch (Throwable t) {
                        LOG.log(Level.SEVERE, t.getMessage(), t);
                    }
                }
            }
            finally {
                this._exited.countDown();
            }
        }

        abstract boolean monitor() throws InterruptedException;

        void shutdown() throws InterruptedException {
            this._shutdown.countDown();
            if (!this._exited.await(10000L, TimeUnit.MILLISECONDS)) {
                this.interrupt();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LockUnlocked
    extends MonitorThread {
        LockUnlocked(Mongo pMongo, DistributedLockSvcOptions pSvcOptions, Map<String, DistributedLock> pLocks) {
            super("Mongo-Distributed-Lock-LockUnlocked-" + System.currentTimeMillis(), pMongo, pSvcOptions, pLocks);
        }

        @Override
        boolean monitor() throws InterruptedException {
            for (String lockName : this._locks.keySet()) {
                DistributedLock lock = (DistributedLock)this._locks.get(lockName);
                if (lock.isLocked() || LockDao.isLocked(this._mongo, lockName, this._svcOptions)) continue;
                lock.wakeupBlocked();
            }
            return this._shutdown.await(this._svcOptions.getLockUnlockedFrequency(), TimeUnit.MILLISECONDS);
        }
    }

    static class LockTimeout
    extends MonitorThread {
        LockTimeout(Mongo pMongo, DistributedLockSvcOptions pSvcOptions) {
            super("Mongo-Distributed-Lock-LockTimeout-" + System.currentTimeMillis(), pMongo, pSvcOptions);
        }

        boolean monitor() throws InterruptedException {
            LockDao.expireInactiveLocks(this._mongo, this._svcOptions);
            return this._shutdown.await(this._svcOptions.getTimeoutFrequency(), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LockHeartbeat
    extends MonitorThread {
        LockHeartbeat(Mongo pMongo, DistributedLockSvcOptions pSvcOptions, Map<String, DistributedLock> pLocks) {
            super("Mongo-Distributed-Lock-LockHeartbeat-" + System.currentTimeMillis(), pMongo, pSvcOptions, pLocks);
        }

        @Override
        boolean monitor() throws InterruptedException {
            for (String lockName : this._locks.keySet()) {
                DistributedLock lock = (DistributedLock)this._locks.get(lockName);
                ObjectId lockId = lock.getLockId();
                if (!lock.isLocked() || lockId == null) continue;
                LockDao.heartbeat(this._mongo, lockName, lockId, lock.getOptions(), this._svcOptions);
            }
            return this._shutdown.await(this._svcOptions.getHeartbeatFrequency(), TimeUnit.MILLISECONDS);
        }
    }
}

