/*
 * Decompiled with CFR 0.152.
 */
package com.deftlabs.logging.mongo;

import com.deftlabs.logging.mongo.LogConfigUtils;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoURI;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public final class LoggingIntTests {
    private Mongo _mongo;
    private static final Logger LOG = Logger.getLogger(LoggingIntTests.class.getName());

    @Test
    public void testSimpleWarning() throws Exception {
        for (int idx = 0; idx < 100; ++idx) {
            LOG.log(Level.WARNING, "this is a test");
        }
        Thread.sleep(1000L);
        Assert.assertEquals((long)100L, (long)this.getCollection().count());
    }

    @BeforeClass
    public static void setupLogger() throws Exception {
        LogManager.getLogManager().readConfiguration(LogConfigUtils.openClasspathResourceUrl("logging.properties"));
    }

    @Before
    public void init() throws Exception {
        this._mongo = new Mongo(new MongoURI("mongodb://127.0.0.1:27017"));
        this.getCollection().remove((DBObject)new BasicDBObject());
    }

    @After
    public void cleanup() {
        this.getCollection().remove((DBObject)new BasicDBObject());
    }

    private DBCollection getCollection() {
        return this._mongo.getDB("mongo-java-logging").getCollection("log");
    }
}

