/*
 * Decompiled with CFR 0.152.
 */
package com.deftlabs.logging.mongo;

import com.deftlabs.logging.mongo.LogMsg;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoURI;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class MongoHandler
extends Handler {
    private Mongo _mongo;
    private volatile DBCollection _collection;
    private String _mongoUri;
    private String _databaseName;
    private String _collectionName;
    private String _pid;
    private String _nodeName;
    private Integer _closeSleepTime;
    private static final Object sMutex = new Object();
    private LinkedBlockingQueue<BasicDBObject> _queue;
    private MsgWriterThread[] _msgWriterThreads;

    public MongoHandler() throws Exception {
        this.configure();
    }

    public void publish(LogRecord pRcd) {
        if (!this.isLoggable(pRcd)) {
            return;
        }
        try {
            if (this._queue == null) {
                this.configure();
            }
            BasicDBObject msg = new BasicDBObject();
            msg.put(LogMsg.LEVEL.field, (Object)pRcd.getLevel().getName());
            msg.put(LogMsg.MSG.field, (Object)pRcd.getMessage());
            msg.put(LogMsg.LOGGER.field, (Object)pRcd.getLoggerName());
            msg.put(LogMsg.MSG_SEQ.field, (Object)pRcd.getSequenceNumber());
            msg.put(LogMsg.THREAD.field, (Object)pRcd.getThreadID());
            msg.put(LogMsg.RES_BUNDLE.field, (Object)pRcd.getResourceBundleName());
            msg.put(LogMsg.TIMESTAMP.field, (Object)pRcd.getMillis());
            msg.put(LogMsg.SRC_METHOD.field, (Object)pRcd.getSourceMethodName());
            msg.put(LogMsg.SRC_CLASS.field, (Object)pRcd.getSourceClassName());
            msg.put(LogMsg.THROWN.field, (Object)MongoHandler.throwableToString(pRcd.getThrown()));
            msg.put(LogMsg.APP_PID.field, (Object)this._pid);
            msg.put(LogMsg.NODE_NAME.field, (Object)this._nodeName);
            if (!this._queue.offer(msg)) {
                this.getErrorManager().error("Queue is full", null, 1);
            }
        }
        catch (Exception e) {
            this.getErrorManager().error(e.getMessage(), e, 1);
        }
    }

    private static String throwableToString(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        t.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    private void sendToMongo(BasicDBObject pMsg) {
        try {
            this.getCollection().insert(new DBObject[]{pMsg});
        }
        catch (Exception me) {
            this.getErrorManager().error(me.getMessage(), me, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBCollection getCollection() throws UnknownHostException {
        if (this._collection != null) {
            return this._collection;
        }
        Object object = sMutex;
        synchronized (object) {
            if (this._collection != null) {
                return this._collection;
            }
            this._mongo = new Mongo(new MongoURI(this._mongoUri));
            DB db = this._mongo.getDB(this._databaseName);
            this._collection = this._mongo.getDB(this._databaseName).getCollection(this._collectionName);
            return this._collection;
        }
    }

    public void flush() {
    }

    public void close() {
        if (this._closeSleepTime != null && this._closeSleepTime > 0) {
            try {
                Thread.sleep(this._closeSleepTime.intValue());
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        if (this._msgWriterThreads == null) {
            return;
        }
        try {
            for (MsgWriterThread t : this._msgWriterThreads) {
                t.interrupt();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void configure() throws Exception {
        LogManager manager = LogManager.getLogManager();
        String clazz = this.getClass().getName();
        String pid = ManagementFactory.getRuntimeMXBean().getName();
        this._pid = pid.substring(0, pid.indexOf("@"));
        this._nodeName = this.getStrProp(clazz + ".nodeName", null);
        if (this._nodeName == null) {
            this._nodeName = InetAddress.getLocalHost().getHostName();
        }
        this._mongoUri = this.getStrProp(clazz + ".mongoUri", "mongodb://127.0.0.1:27017");
        this._databaseName = this.getStrProp(clazz + ".databaseName", "mongo-java-logging");
        this._collectionName = this.getStrProp(clazz + ".collectionName", "log");
        this._closeSleepTime = this.getIntProp(clazz + ".closeSleepTime", 500);
        int writerThreadCount = this.getIntProp(clazz + ".writerThreadCount", 1);
        this.setLevel(this.getLevelProp(clazz + ".level", Level.ALL));
        int maxQueueSize = this.getIntProp(clazz + ".maxQueueSize", 500);
        if (this._queue == null) {
            this._queue = new LinkedBlockingQueue(maxQueueSize);
        }
        if (this._msgWriterThreads == null) {
            this._msgWriterThreads = new MsgWriterThread[writerThreadCount];
            for (int idx = 0; idx < writerThreadCount; ++idx) {
                MsgWriterThread msgWriterThread = new MsgWriterThread();
                msgWriterThread.start();
                msgWriterThread.setName("mongo-java-logging-" + idx);
                this._msgWriterThreads[idx] = msgWriterThread;
            }
        }
        this.setFilter(this.getFilterProp(clazz + ".filter", null));
        try {
            this.setEncoding(this.getStrProp(clazz + ".encoding", null));
        }
        catch (Exception e) {
            try {
                this.setEncoding(null);
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    private Filter getFilterProp(String pName, Filter pDefault) {
        String v = LogManager.getLogManager().getProperty(pName);
        try {
            return v != null ? (Filter)ClassLoader.getSystemClassLoader().loadClass(v).newInstance() : pDefault;
        }
        catch (Exception e) {
            return pDefault;
        }
    }

    private Level getLevelProp(String pName, Level pDefault) {
        String v = LogManager.getLogManager().getProperty(pName);
        if (v == null) {
            return pDefault;
        }
        try {
            return Level.parse(v.trim());
        }
        catch (Exception e) {
            return pDefault;
        }
    }

    private String getStrProp(String pName, String pDefault) {
        String v = LogManager.getLogManager().getProperty(pName);
        return v == null ? pDefault : v.trim();
    }

    private boolean getBoolProp(String pName, boolean pDefault) {
        String v = LogManager.getLogManager().getProperty(pName);
        if (v == null) {
            return pDefault;
        }
        if ((v = v.toLowerCase()).equals("true") || v.equals("1")) {
            return true;
        }
        if (v.equals("false") || v.equals("0")) {
            return false;
        }
        return pDefault;
    }

    private int getIntProp(String pName, int pDefault) {
        String v = LogManager.getLogManager().getProperty(pName);
        if (v == null) {
            return pDefault;
        }
        try {
            return Integer.parseInt(v.trim());
        }
        catch (Exception e) {
            return pDefault;
        }
    }

    private class MsgWriterThread
    extends Thread {
        private MsgWriterThread() {
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        MongoHandler.this.sendToMongo((BasicDBObject)MongoHandler.this._queue.take());
                    }
                }
                catch (InterruptedException ie) {
                }
                catch (Throwable t) {
                    if (t instanceof Exception) {
                        MongoHandler.this.getErrorManager().error(t.getMessage(), (Exception)t, 1);
                        continue;
                    }
                    MongoHandler.this.getErrorManager().error(t.getMessage(), null, 1);
                    continue;
                }
                break;
            }
        }
    }
}

