/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.openfeature;

import com.devcycle.sdk.server.common.api.IDevCycleClient;
import com.devcycle.sdk.server.common.model.DevCycleUser;
import com.devcycle.sdk.server.common.model.Variable;
import dev.openfeature.sdk.ErrorCode;
import dev.openfeature.sdk.EvaluationContext;
import dev.openfeature.sdk.FeatureProvider;
import dev.openfeature.sdk.Metadata;
import dev.openfeature.sdk.ProviderEvaluation;
import dev.openfeature.sdk.Reason;
import dev.openfeature.sdk.Structure;
import dev.openfeature.sdk.Value;
import dev.openfeature.sdk.exceptions.ProviderNotReadyError;
import dev.openfeature.sdk.exceptions.TypeMismatchError;
import java.util.Map;

public class DevCycleProvider
implements FeatureProvider {
    private static final String PROVIDER_NAME = "DevCycle";
    private final IDevCycleClient devcycleClient;

    public DevCycleProvider(IDevCycleClient devcycleClient) {
        this.devcycleClient = devcycleClient;
    }

    public Metadata getMetadata() {
        return () -> "DevCycle " + this.devcycleClient.getSDKPlatform();
    }

    public ProviderEvaluation<Boolean> getBooleanEvaluation(String key, Boolean defaultValue, EvaluationContext ctx) {
        return this.resolvePrimitiveVariable(key, defaultValue, ctx);
    }

    public ProviderEvaluation<String> getStringEvaluation(String key, String defaultValue, EvaluationContext ctx) {
        return this.resolvePrimitiveVariable(key, defaultValue, ctx);
    }

    public ProviderEvaluation<Integer> getIntegerEvaluation(String key, Integer defaultValue, EvaluationContext ctx) {
        ProviderEvaluation<Integer> eval = this.resolvePrimitiveVariable(key, defaultValue, ctx);
        return eval;
    }

    public ProviderEvaluation<Double> getDoubleEvaluation(String key, Double defaultValue, EvaluationContext ctx) {
        return this.resolvePrimitiveVariable(key, defaultValue, ctx);
    }

    public ProviderEvaluation<Value> getObjectEvaluation(String key, Value defaultValue, EvaluationContext ctx) {
        if (!defaultValue.isStructure()) {
            throw new TypeMismatchError("Default value must be a OpenFeature structure");
        }
        for (String k : defaultValue.asStructure().keySet()) {
            Value v = defaultValue.asStructure().getValue(k);
            if (v.isString() || v.isNumber() || v.isBoolean() || v.isNull()) continue;
            throw new TypeMismatchError("DevCycle JSON objects may only contain strings, numbers, booleans and nulls");
        }
        if (this.devcycleClient.isInitialized()) {
            try {
                DevCycleUser user = DevCycleUser.fromEvaluationContext(ctx);
                Variable<Map> variable = this.devcycleClient.variable(user, key, defaultValue.asStructure().asObjectMap());
                if (variable == null || variable.getIsDefaulted().booleanValue()) {
                    return ProviderEvaluation.builder().value((Object)defaultValue).reason(Reason.DEFAULT.toString()).build();
                }
                if (variable.getValue() instanceof Map) {
                    Value objectValue = new Value(Structure.mapToStructure((Map)variable.getValue()));
                    return ProviderEvaluation.builder().value((Object)objectValue).reason(Reason.TARGETING_MATCH.toString()).build();
                }
                throw new TypeMismatchError("DevCycle variable for key " + key + " is not a JSON object");
            }
            catch (IllegalArgumentException e) {
                return ProviderEvaluation.builder().value((Object)defaultValue).reason(Reason.ERROR.toString()).errorCode(ErrorCode.GENERAL).errorMessage(e.getMessage()).build();
            }
        }
        throw new ProviderNotReadyError("DevCycle client not initialized");
    }

    public void shutdown() {
        this.devcycleClient.close();
    }

    <T> ProviderEvaluation<T> resolvePrimitiveVariable(String key, T defaultValue, EvaluationContext ctx) {
        if (this.devcycleClient.isInitialized()) {
            try {
                DevCycleUser user = DevCycleUser.fromEvaluationContext(ctx);
                Variable<T> variable = this.devcycleClient.variable(user, key, defaultValue);
                if (variable == null || variable.getIsDefaulted().booleanValue()) {
                    return ProviderEvaluation.builder().value(defaultValue).reason(Reason.DEFAULT.toString()).build();
                }
                Object value = variable.getValue();
                if (variable.getType() == Variable.TypeEnum.NUMBER && defaultValue.getClass() == Integer.class) {
                    Number numVal = (Number)value;
                    value = numVal.intValue();
                }
                return ProviderEvaluation.builder().value(value).reason(Reason.TARGETING_MATCH.toString()).build();
            }
            catch (IllegalArgumentException e) {
                return ProviderEvaluation.builder().value(defaultValue).reason(Reason.ERROR.toString()).errorCode(ErrorCode.GENERAL).errorMessage(e.getMessage()).build();
            }
        }
        throw new ProviderNotReadyError("DevCycle client not initialized");
    }
}

