/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.local.managers;

import com.devcycle.sdk.server.common.logging.DevCycleLogger;
import com.launchdarkly.eventsource.CommentEvent;
import com.launchdarkly.eventsource.ConnectStrategy;
import com.launchdarkly.eventsource.EventSource;
import com.launchdarkly.eventsource.FaultEvent;
import com.launchdarkly.eventsource.MessageEvent;
import com.launchdarkly.eventsource.ReadyState;
import com.launchdarkly.eventsource.StartedEvent;
import com.launchdarkly.eventsource.StreamEvent;
import com.launchdarkly.eventsource.StreamException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class SSEManager {
    private EventSource eventSource;
    private static Thread messageHandlerThread;
    private URI uri;

    public SSEManager(URI uri) {
        this.eventSource = this.buildEventSource(uri);
        this.uri = uri;
    }

    public void close() {
        this.eventSource.close();
    }

    public void restart(URI uri, Function<MessageEvent, Void> messageHandler, Function<FaultEvent, Void> errorHandler, Function<StartedEvent, Void> stateHandler) {
        if (this.uri.equals(uri) && this.eventSource != null && (this.eventSource.getState() == ReadyState.OPEN || this.eventSource.getState() == ReadyState.CONNECTING || this.eventSource.getState() == ReadyState.CLOSED)) {
            return;
        }
        this.uri = uri;
        if (this.eventSource != null && this.eventSource.getState() == ReadyState.OPEN) {
            this.eventSource.close();
        }
        if (messageHandlerThread != null) {
            messageHandlerThread.interrupt();
        }
        this.eventSource = this.buildEventSource(uri);
        this.start(messageHandler, errorHandler, stateHandler);
    }

    private EventSource buildEventSource(URI uri) {
        return new EventSource.Builder((ConnectStrategy)ConnectStrategy.http((URI)uri).clientBuilderActions(clientBuilder -> clientBuilder.connectTimeout(6000L, TimeUnit.SECONDS).readTimeout(6000L, TimeUnit.SECONDS).writeTimeout(6000L, TimeUnit.SECONDS))).build();
    }

    private boolean start(Function<MessageEvent, Void> messageHandler, Function<FaultEvent, Void> errorHandler, Function<StartedEvent, Void> stateHandler) {
        switch (this.eventSource.getState()) {
            case CONNECTING: 
            case OPEN: {
                break;
            }
            case CLOSED: 
            case RAW: {
                try {
                    this.eventSource.start();
                    break;
                }
                catch (StreamException e) {
                    DevCycleLogger.error("Error starting event source", e);
                    return false;
                }
            }
        }
        messageHandlerThread = new Thread(new SSEMessageHandler(this.eventSource, messageHandler, errorHandler, stateHandler));
        messageHandlerThread.start();
        return true;
    }

    private static class SSEMessageHandler
    implements Runnable {
        private final Function<MessageEvent, Void> messageHandler;
        private final Function<FaultEvent, Void> errorHandler;
        private final Function<StartedEvent, Void> stateHandler;
        private final EventSource sse;

        public SSEMessageHandler(EventSource sse, Function<MessageEvent, Void> messageHandler, Function<FaultEvent, Void> errorHandler, Function<StartedEvent, Void> stateHandler) {
            this.messageHandler = messageHandler;
            this.errorHandler = errorHandler;
            this.stateHandler = stateHandler;
            this.sse = sse;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        StreamEvent event;
                        if ((event = this.sse.readAnyEvent()) instanceof MessageEvent) {
                            this.messageHandler.apply((MessageEvent)event);
                            continue;
                        }
                        if (event instanceof FaultEvent) {
                            this.errorHandler.apply((FaultEvent)event);
                            continue;
                        }
                        if (event instanceof StartedEvent) {
                            this.stateHandler.apply((StartedEvent)event);
                            continue;
                        }
                        if (event instanceof CommentEvent) {
                            this.messageHandler.apply(new MessageEvent(((CommentEvent)event).getText()));
                            continue;
                        }
                        DevCycleLogger.warning("Unknown event type: " + event.getClass().getName());
                    }
                }
                catch (StreamException e) {
                    DevCycleLogger.warning("Error reading event");
                    DevCycleLogger.warning(e.getMessage());
                    continue;
                }
                break;
            }
        }
    }
}

