/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.local.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

public class RequestEvent {
    @Schema(required=true, description="Custom event type")
    private String customType;
    @Schema(description="DevCycleEvent type")
    private String type;
    @Schema(description="User ID")
    private String user_id;
    @Schema(description="Custom event target / subject of event. Contextual to event type")
    private String target;
    @Schema(description="Unix epoch time the event occurred according to client")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'hh:mm:ss.SSS'Z'")
    private String date;
    @Schema(description="Unix epoch time the event occurred according to client")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'hh:mm:ss.SSS'Z'")
    private Date clientDate;
    @Schema(description="Value for numerical events. Contextual to event type")
    private BigDecimal value;
    @Schema(description="Extra JSON metadata for event. Contextual to event type")
    private Object metaData;
    @Schema(description="Feature variation map")
    private Map<String, String> featureVars;

    private static String $default$type() {
        return "customEvent";
    }

    public static RequestEventBuilder builder() {
        return new RequestEventBuilder();
    }

    public String getCustomType() {
        return this.customType;
    }

    public String getType() {
        return this.type;
    }

    public String getUser_id() {
        return this.user_id;
    }

    public String getTarget() {
        return this.target;
    }

    public String getDate() {
        return this.date;
    }

    public Date getClientDate() {
        return this.clientDate;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public Object getMetaData() {
        return this.metaData;
    }

    public Map<String, String> getFeatureVars() {
        return this.featureVars;
    }

    public void setCustomType(String customType) {
        this.customType = customType;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUser_id(String user_id) {
        this.user_id = user_id;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'hh:mm:ss.SSS'Z'")
    public void setDate(String date) {
        this.date = date;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'hh:mm:ss.SSS'Z'")
    public void setClientDate(Date clientDate) {
        this.clientDate = clientDate;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public void setMetaData(Object metaData) {
        this.metaData = metaData;
    }

    public void setFeatureVars(Map<String, String> featureVars) {
        this.featureVars = featureVars;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestEvent)) {
            return false;
        }
        RequestEvent other = (RequestEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$customType = this.getCustomType();
        String other$customType = other.getCustomType();
        if (this$customType == null ? other$customType != null : !this$customType.equals(other$customType)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$user_id = this.getUser_id();
        String other$user_id = other.getUser_id();
        if (this$user_id == null ? other$user_id != null : !this$user_id.equals(other$user_id)) {
            return false;
        }
        String this$target = this.getTarget();
        String other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        Date this$clientDate = this.getClientDate();
        Date other$clientDate = other.getClientDate();
        if (this$clientDate == null ? other$clientDate != null : !((Object)this$clientDate).equals(other$clientDate)) {
            return false;
        }
        BigDecimal this$value = this.getValue();
        BigDecimal other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Object this$metaData = this.getMetaData();
        Object other$metaData = other.getMetaData();
        if (this$metaData == null ? other$metaData != null : !this$metaData.equals(other$metaData)) {
            return false;
        }
        Map<String, String> this$featureVars = this.getFeatureVars();
        Map<String, String> other$featureVars = other.getFeatureVars();
        return !(this$featureVars == null ? other$featureVars != null : !((Object)this$featureVars).equals(other$featureVars));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $customType = this.getCustomType();
        result = result * 59 + ($customType == null ? 43 : $customType.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $user_id = this.getUser_id();
        result = result * 59 + ($user_id == null ? 43 : $user_id.hashCode());
        String $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        Date $clientDate = this.getClientDate();
        result = result * 59 + ($clientDate == null ? 43 : ((Object)$clientDate).hashCode());
        BigDecimal $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Object $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : $metaData.hashCode());
        Map<String, String> $featureVars = this.getFeatureVars();
        result = result * 59 + ($featureVars == null ? 43 : ((Object)$featureVars).hashCode());
        return result;
    }

    public String toString() {
        return "RequestEvent(customType=" + this.getCustomType() + ", type=" + this.getType() + ", user_id=" + this.getUser_id() + ", target=" + this.getTarget() + ", date=" + this.getDate() + ", clientDate=" + this.getClientDate() + ", value=" + this.getValue() + ", metaData=" + this.getMetaData() + ", featureVars=" + this.getFeatureVars() + ")";
    }

    public RequestEvent(String customType, String type, String user_id, String target, String date, Date clientDate, BigDecimal value, Object metaData, Map<String, String> featureVars) {
        this.customType = customType;
        this.type = type;
        this.user_id = user_id;
        this.target = target;
        this.date = date;
        this.clientDate = clientDate;
        this.value = value;
        this.metaData = metaData;
        this.featureVars = featureVars;
    }

    public RequestEvent() {
        this.type = RequestEvent.$default$type();
    }

    public static class RequestEventBuilder {
        private String customType;
        private boolean type$set;
        private String type$value;
        private String user_id;
        private String target;
        private String date;
        private Date clientDate;
        private BigDecimal value;
        private Object metaData;
        private Map<String, String> featureVars;

        RequestEventBuilder() {
        }

        public RequestEventBuilder customType(String customType) {
            this.customType = customType;
            return this;
        }

        public RequestEventBuilder type(String type) {
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        public RequestEventBuilder user_id(String user_id) {
            this.user_id = user_id;
            return this;
        }

        public RequestEventBuilder target(String target) {
            this.target = target;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'hh:mm:ss.SSS'Z'")
        public RequestEventBuilder date(String date) {
            this.date = date;
            return this;
        }

        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'hh:mm:ss.SSS'Z'")
        public RequestEventBuilder clientDate(Date clientDate) {
            this.clientDate = clientDate;
            return this;
        }

        public RequestEventBuilder value(BigDecimal value) {
            this.value = value;
            return this;
        }

        public RequestEventBuilder metaData(Object metaData) {
            this.metaData = metaData;
            return this;
        }

        public RequestEventBuilder featureVars(Map<String, String> featureVars) {
            this.featureVars = featureVars;
            return this;
        }

        public RequestEvent build() {
            String type$value = this.type$value;
            if (!this.type$set) {
                type$value = RequestEvent.$default$type();
            }
            return new RequestEvent(this.customType, type$value, this.user_id, this.target, this.date, this.clientDate, this.value, this.metaData, this.featureVars);
        }

        public String toString() {
            return "RequestEvent.RequestEventBuilder(customType=" + this.customType + ", type$value=" + this.type$value + ", user_id=" + this.user_id + ", target=" + this.target + ", date=" + this.date + ", clientDate=" + this.clientDate + ", value=" + this.value + ", metaData=" + this.metaData + ", featureVars=" + this.featureVars + ")";
        }
    }
}

