/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javascript;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.javascript.compress.CompressionException;
import org.codehaus.mojo.javascript.compress.IsolatedClassLoader;
import org.codehaus.mojo.javascript.compress.JSCompressor;
import org.codehaus.mojo.javascript.compress.JSCompressorProxy;
import org.codehaus.mojo.javascript.compress.JSMinCompressor;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractCompressMojo
extends AbstractMojo {
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private ArtifactRepository localRepository;
    private ArtifactMetadataSource metadataSource;
    private List remoteRepositories;
    private static final NumberFormat INTEGER = NumberFormat.getIntegerInstance();
    private static final String HR = StringUtils.rightPad((String)"", (int)78, (String)"-");
    MavenProject project;
    private Map compressors = new HashMap();
    private int optimizationLevel;
    private int languageVersion;
    private String compressor;
    private boolean skipStats;
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.js"};
    private String[] includes;
    private String[] excludes;
    private String strip;

    public AbstractCompressMojo() {
        this.compressors.put("jsmin", new JSMinCompressor());
    }

    public void execute() throws MojoExecutionException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.getSourceDirectory());
        if (this.includes == null) {
            this.includes = DEFAULT_INCLUDES;
        }
        scanner.setIncludes(this.includes);
        scanner.addDefaultExcludes();
        if (this.excludes != null) {
            scanner.setExcludes(this.excludes);
        }
        scanner.scan();
        String[] files = scanner.getIncludedFiles();
        JSCompressor jscompressor = this.getCompressor();
        this.logStats(HR);
        this.getOutputDirectory().mkdirs();
        long saved = 0L;
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            saved = this.compress(jscompressor, file);
        }
        this.logStats(HR);
        this.logStats("compression saved " + INTEGER.format(saved) + " bytes");
    }

    private File stripDebugs(File file) throws MojoExecutionException {
        if (this.strip == null) {
            return file;
        }
        try {
            String line;
            File stripped = File.createTempFile("stripped", ".js");
            BufferedReader reader = new BufferedReader(new FileReader(file));
            PrintWriter writer = new PrintWriter(stripped);
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith(this.strip)) continue;
                writer.println(line);
            }
            IOUtil.close((Reader)reader);
            IOUtil.close((Writer)writer);
            FileUtils.copyFile((File)stripped, (File)file);
            stripped.delete();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to strip debug code in " + file, (Exception)e);
        }
        return file;
    }

    private JSCompressor getCompressor() throws MojoExecutionException {
        JSCompressorProxy jscompressor;
        Class compressorClass;
        ArtifactResolutionResult dependencies;
        if (this.compressors.containsKey(this.compressor)) {
            return (JSCompressor)this.compressors.get(this.compressor);
        }
        String id = this.compressor.toLowerCase() + "-compressor";
        Artifact compressorArtifact = this.artifactFactory.createDependencyArtifact("org.codehaus.mojo.javascript", id, VersionRange.createFromVersion((String)"1.0-alpha-1-SNAPSHOT"), "jar", null, "runtime");
        Artifact originatingArtifact = this.artifactFactory.createBuildArtifact("dummy", "dummy", "1.0", "jar");
        try {
            dependencies = this.artifactResolver.resolveTransitively(Collections.singleton(compressorArtifact), originatingArtifact, this.localRepository, this.remoteRepositories, this.metadataSource, null);
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)("Failed to load compressor artifact " + compressorArtifact.toString()));
            throw new MojoExecutionException("Failed to load compressor artifact" + compressorArtifact.toString(), e);
        }
        IsolatedClassLoader classLoader = new IsolatedClassLoader((Collection)dependencies.getArtifacts());
        this.compressor = StringUtils.capitalize((String)this.compressor);
        String compressorClassName = "org.codehaus.mojo.javascript.compress." + this.compressor + "Compressor";
        try {
            compressorClass = classLoader.loadClass(compressorClassName);
        }
        catch (ClassNotFoundException e) {
            this.getLog().info((CharSequence)("Failed to load compressor class " + compressorClassName));
            throw new MojoExecutionException("Failed to load compressor class" + compressorClassName, (Exception)e);
        }
        try {
            jscompressor = new JSCompressorProxy(compressorClass.newInstance());
        }
        catch (Exception e) {
            this.getLog().info((CharSequence)("Failed to create a isolated-classloader proxy for " + compressorClassName));
            throw new MojoExecutionException("Failed to create a isolated-classloader proxy for " + compressorClassName, e);
        }
        this.getLog().info((CharSequence)("Compressing javascript using " + this.compressor));
        this.compressors.put(this.compressor, jscompressor);
        return jscompressor;
    }

    private long compress(JSCompressor jscompressor, String file) throws MojoExecutionException {
        String name = file;
        if (this.getExtension() != null) {
            int ext = file.lastIndexOf(46);
            name = file.substring(0, ext) + "-" + this.getExtension() + file.substring(ext);
        }
        File compressed = new File(this.getOutputDirectory(), name);
        compressed.getParentFile().mkdirs();
        File in = new File(this.getSourceDirectory(), file);
        if (in.equals(compressed)) {
            try {
                File temp = File.createTempFile("compress", ".js");
                long size = this.compress(in, temp, jscompressor);
                FileUtils.copyFile((File)temp, (File)compressed);
                temp.delete();
                return size;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error creating temp file for compression", (Exception)e);
            }
        }
        return this.compress(in, compressed, jscompressor);
    }

    private long compress(File in, File compressed, JSCompressor jscompressor) throws MojoExecutionException {
        if (in.length() > 0L) {
            File stripped = this.stripDebugs(in);
            try {
                jscompressor.compress(stripped, compressed, this.optimizationLevel, this.languageVersion);
            }
            catch (CompressionException e) {
                throw new MojoExecutionException("Failed to compress Javascript file " + e.getScript(), (Exception)((Object)e));
            }
            String describe = in.getName() + " (" + INTEGER.format(in.length()) + " bytes) ";
            String title = StringUtils.rightPad((String)describe, (int)60, (String)".");
            this.logStats(title + " compressed at " + this.ratio(compressed, in) + "%");
            return in.length() - compressed.length();
        }
        try {
            compressed.createNewFile();
            this.getLog().info((CharSequence)(in.getName() + " was zero length; not compressed."));
            return 0L;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error handling zero length file.", (Exception)e);
        }
    }

    private long ratio(File compressed, File in) {
        long length = in.length();
        if (length == 0L) {
            return 0L;
        }
        return (length - compressed.length()) * 100L / length;
    }

    private void logStats(String line) {
        if (this.skipStats) {
            return;
        }
        this.getLog().info((CharSequence)line);
    }

    public abstract String getExtension();

    protected abstract File getOutputDirectory();

    protected abstract File getSourceDirectory();

    protected void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }
}

