/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javascript;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.javascript.AbstractJavascriptMojo;
import org.codehaus.mojo.javascript.assembler.Assembler;
import org.codehaus.mojo.javascript.assembler.AssemblerReader;
import org.codehaus.mojo.javascript.assembler.AssemblerReaderManager;
import org.codehaus.mojo.javascript.assembler.Script;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public abstract class CompileMojo
extends AbstractJavascriptMojo {
    protected AssemblerReaderManager assemblerReaderManager;

    public abstract File getDescriptor();

    public abstract String getDescriptorFormat();

    public abstract File getOutputDirectory();

    public abstract File getSourceDirectory();

    public abstract String[] getDefaultIncludes();

    public abstract String[] getIncludes();

    public abstract String[] getExcludes();

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.getSourceDirectory().exists()) {
            this.getLog().warn((CharSequence)("No source directory exists at: " + this.getSourceDirectory() + "... continuing anyway."));
            return;
        }
        this.getOutputDirectory().mkdirs();
        Set merged = this.assemble();
        String[] includes = this.getIncludes();
        if (includes == null) {
            includes = this.getDefaultIncludes();
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.getSourceDirectory());
        scanner.setExcludes(this.getExcludes());
        scanner.addDefaultExcludes();
        scanner.setIncludes(includes);
        scanner.scan();
        try {
            String[] files = scanner.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                String file = files[i];
                if (merged.contains(file)) continue;
                File source = new File(this.getSourceDirectory(), file);
                File dest = new File(this.getOutputDirectory(), file);
                dest.getParentFile().mkdir();
                FileUtils.copyFile((File)source, (File)dest);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy source files to " + this.getOutputDirectory(), (Exception)e);
        }
    }

    protected Set assemble() throws MojoExecutionException {
        Assembler assembler;
        File descriptor = this.getDescriptor();
        String descriptorFormat = this.getDescriptorFormat();
        if (descriptor == null) {
            return Collections.EMPTY_SET;
        }
        if (!descriptor.exists()) {
            if (descriptor.getName().equals(this.project.getArtifactId() + ".xml")) {
                this.getLog().info((CharSequence)"No default assembler descriptor - just copy scripts");
                return Collections.EMPTY_SET;
            }
            throw new MojoExecutionException("The assembler descriptor does not exists : " + descriptor);
        }
        if (descriptorFormat == null) {
            descriptorFormat = "default";
            if (descriptor.getName().toLowerCase().endsWith(".jsb")) {
                descriptorFormat = "jsbuilder";
            }
        }
        try {
            AssemblerReader reader = this.assemblerReaderManager.getAssemblerReader(descriptorFormat);
            assembler = reader.getAssembler(descriptor);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to read the assembler descriptor " + descriptor.getAbsolutePath(), e);
        }
        return this.assemble(assembler);
    }

    private Set assemble(Assembler assembler) throws MojoExecutionException {
        HashSet<String> merged = new HashSet<String>();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.getSourceDirectory());
        scanner.setExcludes(this.getExcludes());
        scanner.addDefaultExcludes();
        for (Script script : assembler.getScripts()) {
            String fileName = script.getFileName();
            PrintWriter writer = null;
            try {
                File target = new File(this.getOutputDirectory(), fileName);
                target.getParentFile().mkdirs();
                writer = new PrintWriter(target);
                List scriptOrderedIncludes = script.getIncludes();
                for (String scriptInclude : scriptOrderedIncludes) {
                    scanner.setIncludes(new String[]{scriptInclude});
                    scanner.scan();
                    String[] files = scanner.getIncludedFiles();
                    for (int i = 0; i < files.length; ++i) {
                        String file = files[i];
                        File source = new File(this.getSourceDirectory().getAbsolutePath() + "/" + file);
                        IOUtil.copy((Reader)new FileReader(source), (Writer)writer);
                        writer.println();
                        merged.add(file);
                    }
                }
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException("Failed to write merged file " + fileName, (Exception)e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(writer);
                    throw throwable;
                }
            }
            IOUtil.close((Writer)writer);
        }
        return merged;
    }
}

