/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javascript;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.javascript.archive.JavascriptArchiver;

public class PackageMojo
extends AbstractMojo {
    private MavenProject project;
    MavenProjectHelper projectHelper;
    private File outputDirectory;
    private String finalName;
    private JavascriptArchiver archiver;
    private String classifier;
    private File manifest;
    private File scriptsDirectory;

    public void execute() throws MojoExecutionException {
        File jsarchive = new File(this.outputDirectory, this.finalName + "." + "jar");
        try {
            if (this.manifest != null) {
                this.archiver.setManifest(this.manifest);
            } else {
                this.archiver.createDefaultManifest(this.project);
            }
            this.archiver.addDirectory(this.scriptsDirectory);
            String groupId = this.project.getGroupId();
            String artifactId = this.project.getArtifactId();
            this.archiver.addFile(this.project.getFile(), "META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml");
            this.archiver.setDestFile(jsarchive);
            this.archiver.createArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create the javascript archive", e);
        }
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.project, "javascript", this.classifier, jsarchive);
        } else {
            this.project.getArtifact().setFile(jsarchive);
        }
    }
}

