/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javascript.test.qunit;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Global;

public class RhinoRuntime {
    protected final Global global = new Global();
    protected final Context context = this.createAndInitializeContext(this.global);
    protected final Scriptable scope = this.context.initStandardObjects((ScriptableObject)this.global);

    public void putGlobal(String name, Object obj) {
        this.scope.put(name, this.scope, (Object)Context.toObject((Object)obj, (Scriptable)this.scope));
    }

    public Object getGlobal(String name) {
        return this.scope.get(name, this.scope);
    }

    public String execStringFunction(String function, String name, Object ... args) {
        Function fn = this.context.compileFunction(this.scope, "function() {" + function + "}", name, 1, null);
        return (String)fn.call(this.context, this.scope, this.scope, args);
    }

    public String[] execStringArrayFunction(String function, String name, Object ... args) {
        NativeArray results = this.execNativeArrayFunction(function, name, this.context, this.scope, args);
        if (results == null) {
            return null;
        }
        String[] strArray = new String[(int)results.getLength()];
        for (int i = 0; i < strArray.length; ++i) {
            strArray[i] = (String)results.get(i, (Scriptable)results);
        }
        return strArray;
    }

    public NativeArray execNativeArrayFunction(String function, String name, Object ... args) {
        Function fn = this.context.compileFunction(this.scope, "function() {" + function + "}", name, 1, null);
        return (NativeArray)fn.call(this.context, this.scope, this.scope, args);
    }

    public void exec(String script, String name) {
        this.context.compileString(script, name, 1, null).exec(this.context, this.scope);
    }

    public void execClasspathScript(String path) throws IOException {
        InputStreamReader in = new InputStreamReader(this.context.getClass().getClassLoader().getResourceAsStream(path));
        this.compileAndExec(in, "classpath:" + path);
        ((Reader)in).close();
    }

    public void execScriptFile(File file) throws IOException {
        FileReader in = new FileReader(file);
        this.compileAndExec(in, file.getName());
        ((Reader)in).close();
    }

    public void compileAndExec(Reader in, String name) throws IOException {
        this.context.compileReader(in, name, 1, null).exec(this.context, this.scope);
    }

    private Context createAndInitializeContext(Global global) {
        Context myContext = ContextFactory.getGlobal().enter();
        global.init(myContext);
        myContext.setOptimizationLevel(-1);
        myContext.setLanguageVersion(150);
        return myContext;
    }
}

