/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javascript;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.javascript.AbstractCompressMojo;
import org.codehaus.mojo.javascript.archive.JavascriptArchiver;

public class AttachCompressedMojo
extends AbstractCompressMojo {
    MavenProjectHelper projectHelper;
    private JavascriptArchiver archiver;
    private File compressedDirectory;
    private File buildDirectory;
    private String finalName;
    private String classifier;
    private String scriptClassifier;
    private File scriptsDirectory;
    private File manifest;

    public String getExtension() {
        return this.scriptClassifier;
    }

    protected File getOutputDirectory() {
        return this.compressedDirectory;
    }

    protected File getSourceDirectory() {
        return this.scriptsDirectory;
    }

    public void execute() throws MojoExecutionException {
        super.execute();
        File compressed = new File(this.buildDirectory, this.finalName + "-" + this.classifier + "." + "jar");
        try {
            if (this.manifest != null) {
                this.archiver.setManifest(this.manifest);
            } else {
                this.archiver.createDefaultManifest(this.project);
            }
            this.archiver.addDirectory(this.compressedDirectory);
            String groupId = this.project.getGroupId();
            String artifactId = this.project.getArtifactId();
            this.archiver.addFile(this.project.getFile(), "META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml");
            this.archiver.setDestFile(compressed);
            this.archiver.createArchive();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create the javascript archive", e);
        }
        this.projectHelper.attachArtifact(this.project, "jar", this.classifier, compressed);
    }
}

