/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javascript.test.qunit;

import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterManager;

public class ReportCallbacks {
    protected static final String DEFAULT_MODULE = "default";
    protected static final String DEFAULT_TEST = "no test";
    protected String currentModule = "default";
    protected String currentTest = "no test";
    protected final ReporterManager reportManager;

    public ReportCallbacks(ReporterManager reportManager) {
        this.reportManager = reportManager;
    }

    public void log(Boolean result, String message) {
        if (!result.booleanValue()) {
            ReportEntry entry = new ReportEntry((Object)this, this.getTestName(), message);
            this.reportManager.testFailed(entry);
        } else {
            this.reportManager.writeMessage("log: " + message);
        }
    }

    public void moduleStart(String name, Object testEnvironment) {
        this.currentModule = name;
    }

    public void moduleDone(String name, Long failures, Long total) {
        this.currentModule = DEFAULT_MODULE;
    }

    public void testStart(String name, Object testEnvironment) {
        this.currentTest = name;
        ReportEntry entry = new ReportEntry((Object)this, this.getTestName(), "Test Started");
        this.reportManager.testStarting(entry);
    }

    public void testDone(String name, Long failures, Long total) {
        ReportEntry entry = new ReportEntry((Object)this, this.getTestName(), "Test Done");
        if (failures > 0L) {
            this.reportManager.testFailed(entry);
        } else {
            this.reportManager.testSucceeded(entry);
        }
        this.currentTest = DEFAULT_TEST;
    }

    public void begin() throws Exception {
        ReportEntry entry = new ReportEntry((Object)this, "qunit", "QUnit Starting");
        this.reportManager.testSetStarting(entry);
    }

    public void done(Long failures, Long total) throws Exception {
        ReportEntry entry = new ReportEntry((Object)this, "qunit", "QUnit Done");
        this.reportManager.testSetCompleted(entry);
    }

    private String getTestName() {
        String name = "";
        if (!this.currentModule.equals(DEFAULT_MODULE)) {
            name = name + this.currentModule + " : ";
        }
        name = name + this.currentTest;
        return name;
    }
}

