/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.examples;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.TopicUpdate;
import com.pushtechnology.diffusion.client.features.control.topics.TopicControl;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.datatype.json.JSON;
import com.pushtechnology.diffusion.datatype.json.JSONDataType;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ControlClientUpdatingJSONTopics {
    private static final String ROOT_TOPIC = "FX";
    private final Session session;
    private final TopicControl topicControl;
    private final TopicUpdate topicUpdate;
    private final TopicSpecification topicSpecification;
    private final JSONDataType jsonDataType = Diffusion.dataTypes().json();

    public ControlClientUpdatingJSONTopics(String serverUrl) throws InterruptedException, ExecutionException, TimeoutException {
        this.session = Diffusion.sessions().principal("control").password("password").open(serverUrl);
        this.topicControl = (TopicControl)this.session.feature(TopicControl.class);
        this.topicUpdate = (TopicUpdate)this.session.feature(TopicUpdate.class);
        this.topicSpecification = Diffusion.newTopicSpecification((TopicType)TopicType.JSON);
        TopicSpecification specification = this.topicSpecification.withProperty("REMOVAL", "When this session closes remove '?FX//'");
        this.topicControl.addTopic(ROOT_TOPIC, specification).get(5L, TimeUnit.SECONDS);
    }

    public void addRates(String currency, String value) {
        this.topicUpdate.addAndSet(ControlClientUpdatingJSONTopics.rateTopicName(currency), this.topicSpecification, JSON.class, (Object)this.jsonDataType.fromJsonString(value));
    }

    public CompletableFuture<?> changeRates(String currency, String jsonString) throws IllegalArgumentException {
        return this.topicUpdate.set(ControlClientUpdatingJSONTopics.rateTopicName(currency), JSON.class, (Object)this.jsonDataType.fromJsonString(jsonString));
    }

    public CompletableFuture<?> removeRates(String currency) {
        String topicName = ControlClientUpdatingJSONTopics.rateTopicName(currency);
        return this.topicControl.removeTopics(topicName);
    }

    public void close() {
        this.session.close();
    }

    private static String rateTopicName(String currency) {
        return String.format("%s/%s", ROOT_TOPIC, Objects.requireNonNull(currency));
    }
}

