/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.gettingstarted;

import com.pushtechnology.diffusion.client.Diffusion;
import com.pushtechnology.diffusion.client.features.Topics;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.client.topics.details.TopicSpecification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribingClient {
    private static final Logger LOG = LoggerFactory.getLogger(SubscribingClient.class);

    public static void main(String ... arguments) throws Exception {
        Session session = Diffusion.sessions().open("ws://host:80");
        Topics topics = (Topics)session.feature(Topics.class);
        topics.addStream(">foo/counter", Long.class, (Topics.ValueStream)new ValueStreamPrintLn());
        topics.subscribe("foo/counter").whenComplete((voidResult, exception) -> {
            if (exception != null) {
                LOG.info("subscription failed", exception);
            }
        });
        Thread.sleep(60000L);
    }

    private static class ValueStreamPrintLn
    extends Topics.ValueStream.Default<Long> {
        private ValueStreamPrintLn() {
        }

        public void onValue(String topicPath, TopicSpecification specification, Long oldValue, Long newValue) {
            System.out.println(topicPath + ":   " + newValue);
        }
    }
}

