/*******************************************************************************
 * Copyright (c) 2014, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.callbacks;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.pushtechnology.diffusion.client.session.Session;

/**
 * Common interface for callback handlers that establish a server side control
 * presence for the client {@link Session session}.
 *
 * @author DiffusionData Limited
 * @since 5.1
 *
 * @deprecated since 6.7
 *             <p>
 *             This interface is only used by deprecated methods and will be
 *             removed in a future release.
 */
@Deprecated
public interface ServerHandler {

    /**
     * Called when the handler has been successfully registered with the server.
     * <P>
     * A session can register at most one a single handler of each type. If
     * there is already a handler registered the operation will fail,
     * {@code registeredHandler} will be closed, and the session error handler
     * will be notified. To change the handler, first
     * {@link Registration#close close} the previous handler.
     *
     * @param registration a reference that allows the handler to be closed
     */
    void onRegistered(Registration registration);

    /**
     * Called if the handler is closed. The handler will be closed if the
     * session is closed after the handler has been registered, or if the
     * handler is unregistered using {@link Registration#close close}.
     *
     * <p>
     * No further calls will be made for the handler.
     */
    void onClose();

    /**
     * Notification of a contextual error related to this handler. This is
     * analogous to an unchecked exception being raised. Situations in which
     * {@code onError} is called include the session being closed before the
     * handler is registered, a communication timeout, or a problem with the
     * provided parameters. No further calls will be made to this handler.
     *
     * @param errorReason a value representing the error; this can be one of
     *        constants defined in {@link ErrorReason}, or a feature-specific
     *        reason
     */
    void onError(ErrorReason errorReason);

    /**
     * Skeleton server handler implementation.
     * <P>
     * The methods on this handler log callbacks at debug level.
     */
    class Default implements ServerHandler {

        private static final Logger LOG =
            LoggerFactory.getLogger(ServerHandler.Default.class);

        @Override
        public void onRegistered(Registration registration) {
            LOG.debug("{} - server handler registered", this);
        }

        @Override
        public void onClose() {
            LOG.debug("{} - server handler closed", this);
        }

        @Override
        public void onError(ErrorReason errorReason) {
            LOG.warn("{} - server handler error, reason={}", this, errorReason);
        }
    }
}
