/*******************************************************************************
 * Copyright (c) 2017, 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to licence terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of DiffusionData. The intellectual and technical
 * concepts contained herein are proprietary to DiffusionData and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.features;

import java.util.List;

import com.pushtechnology.diffusion.client.session.SessionException;
import com.pushtechnology.diffusion.client.types.ErrorReport;

/**
 * Thrown to report one or more {@link ErrorReport}s}.
 *
 * @author DiffusionData Limited
 * @since 6.0
 */
public class ErrorReportsException extends SessionException {

    private static final long serialVersionUID = -2202780395763915132L;

    private final List<ErrorReport> reports;

    /**
     * Constructor.
     */
    public ErrorReportsException(String message, List<ErrorReport> reports) {
        super(message + ": " + reports);
        this.reports = reports;
    }

    /**
     * @return the reports
     */
    public final List<ErrorReport> getReports() {
        return reports;
    }
}
